#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>

namespace maps {
namespace wiki {

enum class SlavesLoadingPolicy
{
    All,
    Limited
};

class BBoxProvider
{
public:
    explicit BBoxProvider(
        ObjectsCache& cache,
        SlavesLoadingPolicy policy = SlavesLoadingPolicy::Limited);

    Geom geometryForObject(const GeoObject& object);

private:
    Geom geometryForObjectImpl(const GeoObject& object);
    Geom dataFromSlaves(const RelationInfos::Range& slavesRange);
    boost::optional<Geom> loadFromDb(TOid objectId, TCommitId maxCommitId);

    ObjectsCache& cache_;
    SlavesLoadingPolicy policy_;
    std::unordered_map<TOid, Geom> bboxCache_;
};

} // namespace wiki
} // namespace maps
