#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include "bbox_context.h"

namespace maps {
namespace wiki {

class BBoxWriter
{
public:
    explicit BBoxWriter(BBoxContext context);

    void setInitialGeom(TOid objectId, const Geom& geom);

    void writeToDb(TCommitId commitId, TOid objectId, const std::string& categoryId, const Geom& geom);

    void flush(pqxx::transaction_base& txn);

    void clearOldBBoxes(pqxx::transaction_base& txn, const TOIds& objectIdsToClear);

private:
    struct Record
    {
        TCommitId commitId;
        TOid objectId;
        std::string categoryId;
        Geom geom;
    };

    BBoxContext context_;
    std::vector<Record> records_;
    std::unordered_map<TOid, Geom> currentCachedGeometries_;
};

} // namespace wiki
} // namespace maps
