#pragma once

#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <yandex/maps/wiki/configs/editor/categories.h>
#include <maps/libs/common/include/exception.h>
#include <functional>
#include <memory>
#include <string>

namespace maps {
namespace wiki {

const CachePolicy REVISION_META_CACHE_POLICY {
    TableAttributesLoadPolicy::Skip,
    ServiceAttributesLoadPolicy::Skip,
    DanglingRelationsPolicy::Ignore
};

enum class LoadingDataMode
{
    FromMaster,
    FromLongReadReplica
};

enum class BBoxUpdateAction
{
    History,
    View,
    Both
};

inline bool
isHistoryUpdateRequested(BBoxUpdateAction action)
{
    return action != BBoxUpdateAction::View;
}

inline bool
isViewUpdateRequested(BBoxUpdateAction action)
{
    return action != BBoxUpdateAction::History;
}

inline std::string
geomToSqlString(Transaction& txn, const Geom& geom)
{
    return geom.isNull()
        ? "NULL"
        : "ST_GeomFromWkb('" + txn.esc_raw(geom.wkb()) + "', 3395)";
}

template <typename T>
std::string
categoryIdsToArray(const T& categoryIds)
{
    ASSERT(!categoryIds.empty());

    std::string str;
    for (const auto& categoryId : categoryIds) {
        str += str.empty() ? "" : ",";
        str += "'" + plainCategoryIdToCanonical(categoryId) + "'";
    }
    return "ARRAY[" + str + "]";
}

} // namespace wiki
} // namespace maps
