#pragma once

#include "bbox_context.h"
#include "categories_holder.h"

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>

#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <atomic>
#include <mutex>

namespace maps {
namespace wiki {

class ComplexObjectsLoader
{
public:
    ComplexObjectsLoader(
        const BBoxContext& context,
        const CategoriesHolder& categoriesHolder,
        size_t threadPoolSize);

    void run();

    std::map<std::string, TOIds> topLevelComplexObjectIds();

private:
    bool checkRelationToTopLevelObject(const revision::ObjectRevision& rev);

    void loadHistoryGeometryObjects(std::map<TCommitId, TOIds>& commitToObjects);
    void loadHistoryRelations(std::map<TCommitId, TOIds>& commitToObjects);

    template<typename Container, typename Func>
    void doActionInThreadPool(const Container& data, size_t minimumBatchSize, Func func);

    void loadMasterRelationsByCommits(const std::map<TCommitId, TOIds>& commitToObjects);
    TOIds loadMasterRelationsOnCommitInThread(
        pqxx::transaction_base& txn,
        TCommitId commitId,
        const TOIds& slaveObjectIdsToLoad);

    std::map<TCommitId, TOIds> loadNewRelationsForObjects(const TOIds& objectIds);
    std::map<TCommitId, TOIds> loadNewRelationsForObjectsInThread(
        pqxx::transaction_base& txn,
        const TOIds& objectIds);

    BBoxContext context_;
    CategoriesHolder categoriesHolder_;
    BranchContext branchContext_;
    revision::RevisionsGateway gateway_;
    size_t threadPoolSize_;

    std::mutex loadedObjectsIdsMutex_;
    TOIds loadedObjectIds_;

    std::mutex topLevelComplexObjectsMutex_;
    std::map<std::string, TOIds> topLevelComplexObjectIds_;

    std::atomic<bool> failed_;
};

} // namespace wiki
} // namespace maps
