#include "filter_helpers.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/categories.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <yandex/maps/wiki/configs/editor/categories.h>
#include <yandex/maps/wiki/configs/editor/slave_role.h>

namespace maps {
namespace wiki {

namespace rf = revision::filters;

rf::ProxyFilterExpr createObjectsFilter(const StringSet& categoryIds)
{
    if (categoryIds.empty()) {
        return rf::False();
    }

    return rf::Attr::definedAny(plainCategoryIdsToCanonical(categoryIds));
}

rf::ProxyFilterExpr createRelationsFilter(const StringSet& complexCategoryIds)
{
    if (complexCategoryIds.empty()) {
        return rf::False();
    }

    std::unordered_map<std::string, std::unordered_map<std::string, StringSet>> relationsMap;

    for (const auto& categoryId : complexCategoryIds) {
        const auto& category = cfg()->editor()->categories()[categoryId];
        for (const auto& roleId : category.geomSlaveRoleIds()) {
            const auto& slaveRole = category.slaveRole(roleId);
            relationsMap[roleId][categoryId].insert(slaveRole.categoryId());
        }
    }

    std::unique_ptr<rf::ProxyFilterExpr> filter;
    for (const auto& pair : relationsMap) {
        const auto& roleId = pair.first;
        const auto& masterToSlavesMap = pair.second;

        std::unique_ptr<rf::ProxyFilterExpr> rolesFilter;
        for (const auto& pair : masterToSlavesMap) {
            const auto& masterCategoryId = pair.first;
            const auto& slaveCategoryIds = pair.second;

            auto categoriesFilter =
                rf::Attr(ATTR_REL_MASTER) == masterCategoryId &&
                rf::Attr(ATTR_REL_SLAVE).in(slaveCategoryIds);
            if (rolesFilter) {
                *rolesFilter |= std::move(categoriesFilter);
            } else {
                rolesFilter.reset(new rf::ProxyFilterExpr(std::move(categoriesFilter)));
            }
        }

        *rolesFilter &= (rf::Attr(ATTR_REL_ROLE) == roleId);
        if (filter) {
            *filter |= std::move(*rolesFilter);
        } else {
            filter.swap(rolesFilter);
        }
    }
    return std::move(*filter) && rf::Attr(ATTR_REL_ROLE).defined();
}

} // namespace wiki
} // namespace maps
