#include "update_queue.h"

#include <yandex/maps/wiki/common/string_utils.h>

namespace maps {
namespace wiki {
namespace revision_meta {

CommitsQueue::CommitsQueue(
        Transaction& txn,
        TBranchId branchId)
    : txn_(txn)
    , branchId_(branchId)
{}

TCommitIds
CommitsQueue::lockCommits(
    boost::optional<TCommitId> maxCommitId, boost::optional<size_t> commitsLimit)
{
    std::ostringstream query;
    query << "SELECT commit_id"
        << " FROM revision_meta.commits_queue"
        << " WHERE branch_id=" << branchId_;
    if (maxCommitId.is_initialized()) {
        query << " AND commit_id<=" << *maxCommitId;
    }
    if (commitsLimit.is_initialized()) {
        query << " ORDER BY commit_id LIMIT " << *commitsLimit;
    }
    query << " FOR UPDATE NOWAIT";


    TCommitIds commitIds;
    try {
        for (const auto& row: txn_.exec(query.str())) {
            commitIds.insert(row[0].as<TCommitId>());
        }
    } catch (const pqxx::sql_error& ex) {
        throw QueueLockException()
            << "Locking commits for revision_meta update failed"
            << ", branch id " << branchId_ << ": "
            << ex.what();
    }

    return commitIds;
}

void
CommitsQueue::deleteCommits(const TCommitIds& commitIds)
{
    if (commitIds.empty()) {
        return;
    }
    std::ostringstream query;
    query << "DELETE FROM revision_meta.commits_queue "
          << "WHERE branch_id=" << branchId_ << " AND commit_id IN ("
          << common::join(commitIds, ',')
          << ")";
    txn_.exec(query.str());
}

void
CommitsQueue::clear()
{
    std::ostringstream query;
    query << "DELETE FROM revision_meta.commits_queue"
          << " WHERE branch_id=" << branchId_;
    txn_.exec(query.str());
}

void
CommitsQueue::push(TCommitId commitId)
{
    std::ostringstream query;
    query << "INSERT INTO revision_meta.commits_queue VALUES ("
        << branchId_ << ", "
        << commitId
        << ")";
    txn_.exec(query.str());
}

} // namespace revision_meta
} // namespace wiki
} // namespace maps
