#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/threadutils/thread_observer.h>
#include <yandex/maps/wiki/revision/branch.h>
#include <yandex/maps/wiki/revision/branch_manager.h>

namespace maps {
namespace wiki {

/**
 * Background revision_meta updater for specific branch.
 */
class RevisionMetaUpdater: public ThreadObserver<RevisionMetaUpdater>
{
public:
    RevisionMetaUpdater(TBranchId branchId, size_t threadPoolSize);

private:
    friend class ThreadObserver<RevisionMetaUpdater>;
    std::string name() const { return name_; }
    void onStart() { INFO() << "Revision_meta updater started, branch id " << branchId_; }
    void doWork();
    void onStop() { INFO() << "Revision_meta updater stopped, branch id " << branchId_; }

    TBranchId branchId_;
    size_t threadPoolSize_;
    std::string name_;
};

/**
 * Main background worker for revision_meta update.
 * Manages updaters list according to actual branches list:
 *   starts updaters for trunk/stable branches
 *   stops updaters for archive/deleted branches.
 * Single updater for each branch.
 */
class RevisionMetaUpdatersManager: public ThreadObserver<RevisionMetaUpdatersManager>
{
public:
    /**
     * @param threadsPerBranch thread pool size for each updater (== for each branch)
     */
    explicit RevisionMetaUpdatersManager(size_t threadsPerUpdater);

private:
    void startActualBranchWorkers(
        revision::BranchManager::Branches&& actualBranches);

    // terminate workers for obsolete archive and deleted branches
    void stopObsoleteBranchWorkers(
        const std::set<TBranchId>& actualBranchIds,
        Transaction& txn);

    friend class ThreadObserver<RevisionMetaUpdatersManager>;
    std::string name() const noexcept { return "revision_meta updaters manager"; }
    void onStart() {}
    void doWork();
    void onStop() {}

    size_t threadsPerUpdater_;
    std::map<TBranchId, std::unique_ptr<RevisionMetaUpdater>> updaters_;
};

} // namespace wiki
} // namespace maps
