#pragma once

#include "common.h"

namespace maps {
namespace wiki {

class ObjectsCache;
class GeoObject;
class GeoObjectCollection;

class RuntimeDataCalculator
{
public:
    explicit RuntimeDataCalculator(ObjectsCache& cache);

    void operator () (const ObjectPtr& object);
    void operator () (GeoObjectCollection& collection);

private:
    void loadTableAttributes(const ObjectPtr& object);
    void loadTableAttributes(GeoObjectCollection& collection);

    void loadServiceAttributes(const ObjectPtr& object);
    void loadServiceAttributes(GeoObjectCollection& collection);

    StringMap serviceAttributes(TOid id, const std::string& tableName);

    std::map<TOid, StringMap> cacheServiceAttrs_;

    ObjectsCache& cache_;
};

} // namespace wiki
} // namespace maps
