#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/context.h>
#include "topo_object_data.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class CreateIntersectionsParser
{
public:
    void parse(common::FormatType formatType, const std::string& requestBody);

    const TopoObjectDataCollection& objects() const { return objects_; }
    const ObjectEditContextPtr& editContext() const { return editContext_; }

private:
    template <common::FormatType formatType>
    void parseImpl(const std::string& requestBody);

    TopoObjectDataCollection objects_;
    ObjectEditContextPtr editContext_;
};

} // namespace wiki
} // namespace maps
