#include "formatter.h"
#include "formatter_context.h"
#include "xml_formatter.h"
#include "json_formatter.h"

namespace maps {
namespace wiki {

Formatter::Formatter(std::unique_ptr<FormatterContext>&& context)
        : context_(std::move(context))
{
}

Formatter::~Formatter()
{
}

std::unique_ptr<Formatter>
Formatter::create(common::FormatType formatType, std::unique_ptr<FormatterContext>&& context)
{
    switch (formatType)
    {
        case common::FormatType::XML:
            return make_unique<XMLFormatter>(std::move(context));
        case common::FormatType::JSON:
            return make_unique<JSONFormatter>(std::move(context));
    }
    return nullptr;
}

std::unique_ptr<Formatter>
Formatter::create(common::FormatType formatType)
{
    return create(formatType, make_unique<FormatterContext>());
}

}//wiki
}//maps
