#pragma once

#include "maps/wikimap/mapspro/services/editor/src/common.h"
#include "maps/wikimap/mapspro/services/editor/src/srv_attrs/object_predicates.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/business_photos.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/clone_object.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/create_intersections.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/create_token.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/distribute_flats.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/get_geolocks.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/get_history.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/get_suggest.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/get_topology.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/getasyncresult.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/getobject.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/getrenderersublayers.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/getrenderersublayers2.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/getslaveinfos.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/tile/gettile.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/make_junction.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_cleanup_relations.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_category.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_filter.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_ids.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_lasso.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_lasso_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_poi_business_id.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_poi_conflicts.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_pois_conflicts.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_pois_conflicts_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_query_title.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_attributes.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_attributes_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_merge.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_move.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_move_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_relation.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_relations.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_relations_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_snap.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_snap_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_state.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_state_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_sync_geometry.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_sync_geometry_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_union.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/objects_update_union_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/point_to_bld.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/branches/get.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/branches/save_state.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/branches/save_type.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commit_diff/get_branch_diff.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commit_diff/get_commit_diff.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commit_diff/get_commit_geom_diff.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commits/approve.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commits/get_commit.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commits/get_dependent.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/commits/revert.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/filters/delete_filter.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/filters/get_expression.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/filters/get_filters.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/filters/save_expression.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/filters/save_filter.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/routing/get_route_time.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/routing/objects_query_path.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/routing/objects_query_route_diff.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/save_object/saveobject.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/comments/clear.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/comments/create.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/comments/delete.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/comments/feed.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/comments/stat.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/get_feed.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/get_feedback_task_history.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/get_feedback_task_stat.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/get_social_event.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/get_subscriptions.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/dashboard.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/dashboard_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/get_stat.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/get_task.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/get_task_by_commit.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/get_tasks.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/regions.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_acquire.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_acquire_blocking.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_close.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_defer.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_release.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_resolve.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/social/moderation/tasks_stat.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/sprav/create_task.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/sprav/get_tasks.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/tools_resolve_pois_conflicts.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/tools_resolve_pois_conflicts_meta.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/tools/pedestrian/task_load_points.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/tools/pedestrian/task_points.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/tools/pedestrian/task_save_points.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/validation/get_exclusions.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/validation/save_exclusion.h"
#include "maps/wikimap/mapspro/services/editor/src/actions/validation/view_exclusion.h"
#include <maps/wikimap/mapspro/libs/controller/include/asyncbasecontroller.h>

#include <list>
#include <string>


namespace maps::wiki {

using namespace controller;

class FormatterContext;
class Formatter
{
public:
    explicit Formatter(std::unique_ptr<FormatterContext>&& context);
    virtual ~Formatter();

    static std::unique_ptr<Formatter> create(common::FormatType formatType, std::unique_ptr<FormatterContext>&& context);
    static std::unique_ptr<Formatter> create(common::FormatType formatType);

    virtual std::string formatException(const maps::Exception& ex, bool withBacktrace) = 0;

    virtual std::string operator ()(const AsyncTaskResult& asyncResult) = 0;
    virtual std::string operator ()(const ResultType<AsyncBaseController>& result) = 0;
    virtual std::string operator ()(const ResultType<BusinessPhotos>& result) = 0;
    virtual std::string operator ()(const ResultType<ClearUserComments>& result) = 0;
    virtual std::string operator ()(const ResultType<CloneObject>& result) = 0;
    virtual std::string operator ()(const ResultType<CommentsCreate>& result) = 0;
    virtual std::string operator ()(const ResultType<CommentsDelete>& result) = 0;
    virtual std::string operator ()(const ResultType<CommitsApprove>& result) = 0;
    virtual std::string operator ()(const ResultType<CommitsRevert>& result) = 0;
    virtual std::string operator ()(const ResultType<CreateIntersections>& result) = 0;
    virtual std::string operator ()(const ResultType<CreateSpravTask>&)=0;
    virtual std::string operator ()(const ResultType<CreateToken>& result) = 0;
    virtual std::string operator ()(const ResultType<DeleteFilter>& result) = 0;
    virtual std::string operator ()(const ResultType<DistributeFlats>& result) = 0;
    virtual std::string operator ()(const ResultType<GetAsyncResult>& result) = 0;
    virtual std::string operator ()(const ResultType<GetBranchDiff>& result) = 0;
    virtual std::string operator ()(const ResultType<GetBranches>& result) = 0;
    virtual std::string operator ()(const ResultType<GetCommentsFeed>& result) = 0;
    virtual std::string operator ()(const ResultType<GetCommentsStat>& result) = 0;
    virtual std::string operator ()(const ResultType<GetCommit>& result) = 0;
    virtual std::string operator ()(const ResultType<GetCommitDiff>& result) = 0;
    virtual std::string operator ()(const ResultType<GetCommitGeomDiff>& result) = 0;
    virtual std::string operator ()(const ResultType<GetDependentCommits>& result) = 0;
    virtual std::string operator ()(const ResultType<GetFilterExpression>& result) = 0;
    virtual std::string operator ()(const ResultType<GetFilters>& result) = 0;
    virtual std::string operator ()(const ResultType<GetGeoLocks>& result) = 0;
    virtual std::string operator ()(const ResultType<GetHistory>& result) = 0;
    virtual std::string operator ()(const ResultType<GetLayers>& result) = 0;
    virtual std::string operator ()(const ResultType<GetLayers2>& result) = 0;
    virtual std::string operator ()(const ResultType<GetObject>& result) = 0;
    virtual std::string operator ()(const ResultType<GetObjectsByTile>& result) = 0;
    virtual std::string operator ()(const ResultType<GetRegularSocialFeedMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<GetRouteTime>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSlaveInfos>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialEvent>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialFeed>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialFeedbackTaskHistory>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialFeedbackTaskStat>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialModerationStat>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialModerationTask>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialModerationTaskByCommit>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialModerationTasks>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSocialSubscriptions>& result) = 0;
    virtual std::string operator ()(const ResultType<GetSpravTasks>&)=0;
    virtual std::string operator ()(const ResultType<GetSuggest>& result) = 0;
    virtual std::string operator ()(const ResultType<GetTopology>& result) = 0;
    virtual std::string operator ()(const ResultType<GetValidationExclusions>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsCleanupRelations>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryCategory>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryFilter>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryIds>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryJunction>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryLasso>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryLassoMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryPath>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryPoiBusinessId>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryPoiConflicts>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryPoisConflicts>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryPoisConflictsMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ToolsResolvePoisConflicts>& result) = 0;
    virtual std::string operator ()(const ResultType<ToolsResolvePoisConflictsMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryRouteDiff>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsQueryTitle>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateAttributes>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateAttributesMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateMerge>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateMove>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateMoveMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateRelation>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateRelations>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateRelationsMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateSnap>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateSnapMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateState>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateStateMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateSyncGeometry>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateSyncGeometryMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateUnion>& result) = 0;
    virtual std::string operator ()(const ResultType<ObjectsUpdateUnionMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<PointToBld>& result) = 0;
    virtual std::string operator ()(const ResultType<SaveBranchState>& result) = 0;
    virtual std::string operator ()(const ResultType<SaveBranchType>& result) = 0;
    virtual std::string operator ()(const ResultType<SaveExpression>& result) = 0;
    virtual std::string operator ()(const ResultType<SaveFilter>& result) = 0;
    virtual std::string operator ()(const ResultType<SaveObject>& result) = 0;
    virtual std::string operator ()(const ResultType<SaveValidationExclusion>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationDashboard>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationDashboardMeta>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationRegions>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksAcquire>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksAcquireBlocking>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksClose>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksDefer>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksRelease>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksResolve>& result) = 0;
    virtual std::string operator ()(const ResultType<SocialModerationTasksStat>& result) = 0;
    virtual std::string operator ()(const ResultType<ToolsLoadPedestrianPoints>& result) = 0;
    virtual std::string operator ()(const ResultType<ToolsPedestrianPoints>& result) = 0;
    virtual std::string operator ()(const ResultType<ToolsSavePedestrianPoints>& result) = 0;
    virtual std::string operator ()(const ResultType<ViewValidationExclusion>& result) = 0;

protected:
    FormatterContext& context() { return *context_; }

private:
    std::unique_ptr<FormatterContext> context_;
};

} // namespace maps::wiki
