#include "get_route_time_parser.h"

#include "common.h"
#include "json_parser.h"
#include "thread_stop_sequence_parser.h"

#include <maps/wikimap/mapspro/services/editor/src/exception.h>


namespace maps {
namespace wiki {

void GetRouteTimeParser::parse(
        common::FormatType formatType,
        const std::string& requestBody)
{
    if (formatType == common::FormatType::XML) {
        UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryRouteDiff");
    }

    parseJson(requestBody);
}

void GetRouteTimeParser::parseJson(const std::string& requestBody)
{
    const auto json = json::Value::fromString(requestBody);

    const auto& revisionId = json[STR_REVISION_ID];
    if (revisionId.exists()) {
        revisionId_ = boost::lexical_cast<TRevisionId>(revisionId.toString());
    }
    categoryId_ = json[STR_CATEGORY_ID].as<std::string>();

    const auto& elementsDiff = json[STR_ELEMENTS_DIFF];

    const auto& addElementIds = elementsDiff[STR_ADD];
    if (addElementIds.exists()) {
        addElementIds_ = JsonParser::objectIdSet(addElementIds);
    }

    const auto& removeElementIds = elementsDiff[STR_REMOVE];
    if (removeElementIds.exists()) {
        removeElementIds_ = JsonParser::objectIdSet(removeElementIds);
    }

    threadStopSequence_ = parseThreadStopSequence(json[STR_THREAD_STOPS]);
}

const TRevisionId& GetRouteTimeParser::revisionId() const { return revisionId_; }

const std::string& GetRouteTimeParser::categoryId() const { return categoryId_; }

const TOIds& GetRouteTimeParser::addElementIds() const { return addElementIds_; }

const TOIds& GetRouteTimeParser::removeElementIds() const { return removeElementIds_; }

const ThreadStopSequence& GetRouteTimeParser::threadStopSequence() const { return threadStopSequence_; }

} // namespace wiki
} // namespace maps
