#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/actions/routing/thread_stop.h>

#include <yandex/maps/wiki/common/format_type.h>

#include <boost/optional.hpp>

#include <set>
#include <string>
#include <vector>


namespace maps {
namespace wiki {

class GetRouteTimeParser {

public:
    void parse(common::FormatType formatType, const std::string& requestBody);

    // empty in case of new thread
    const TRevisionId& revisionId() const;
    const std::string& categoryId() const;

    const TOIds& addElementIds() const;
    const TOIds& removeElementIds() const;

    const ThreadStopSequence& threadStopSequence() const;
private:
    void parseJson(const std::string& requestBody);

    TRevisionId revisionId_;
    std::string categoryId_;

    TOIds addElementIds_;
    TOIds removeElementIds_;

    ThreadStopSequence threadStopSequence_;
};

} // namespace wiki
} // namespace maps
