#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class GetSuggestParser {
public:
    void parse(common::FormatType formatType, const std::string& requestBody);

    const Geom& geometry() const { return geometry_; }
    const StringMap& attributesValues() const { return attributesValues_; }

private:
    void parseXml(const std::string& requestBody);
    void parseJson(const std::string& requestBody);

    Geom geometry_;
    StringMap attributesValues_;
};

} // namespace wiki
} // namespace maps
