#pragma once

#include "common.h"
#include <maps/wikimap/mapspro/services/editor/src/commit.h>
#include <maps/wikimap/mapspro/services/editor/src/edit_notes.h>

#include <yandex/maps/wiki/common/json_helpers.h>
#include <yandex/maps/wiki/social/task.h>
#include <yandex/maps/wiki/revision/commit.h>
#include <string>

namespace maps {
namespace wiki {

class JsonBuilderStreamHolder
{
public:
    JsonBuilderStreamHolder()
    {
        stream_.precision(GEODETIC_GEOM_PRECISION);
        stream_ << std::fixed;
    }
    std::ostringstream stream_;
};

class JsonBuilder : private JsonBuilderStreamHolder, public json::Builder
{
public:
    JsonBuilder()
        : json::Builder(stream_)
    {}

    std::string str() { return stream_.str(); }
};

void putTaskIds(json::ObjectBuilder& builder, const social::TaskIds& taskIds);

void putEditNotes(
    json::ObjectBuilder& notesBuilder,
    const std::vector<edit_notes::EditNotesTree::Node>& notesNodes);

void putCommitModel(
    json::ObjectBuilder& jsonCommitObject,
    const CommitModel& commitModel);


template <typename Ids>
void
putJsonIds(json::ObjectBuilder& builder, const std::string& key, const Ids& ids)
{
    builder[key] << [&](json::ArrayBuilder arrayBuilder) {
        for (auto id : ids) {
            arrayBuilder << common::idToJson(id);
        }
    };
}

} // namespace wiki
} // namespace maps
