#include "json_formatter.h"
#include "common.h"

#include <maps/libs/json/include/builder.h>
#include <maps/libs/chrono/include/time_point.h>

namespace maps::wiki {

std::string
JSONFormatter::operator ()(const ResultType<CreateSpravTask>& result)
{
    return tokenTaskResponseJson(result.taskName, result.token);
}

std::string
JSONFormatter::operator ()(const ResultType<GetSpravTasks>& result)
{
    json::Builder builder;
    builder << [&](json::ObjectBuilder root) {
        root["tasks"] = [&](json::ArrayBuilder tasks) {
            for (const auto& task : result.tasks) {
                tasks << [&](json::ObjectBuilder taskBuilder) {
                    taskBuilder[STR_ID] = std::to_string(task.id);
                    taskBuilder[STR_STATUS] =
                        task.status == SpravTask::Status::NotSubmitted
                            ? boost::lexical_cast<std::string>(SpravTask::Status::New)
                            : boost::lexical_cast<std::string>(task.status);
                    taskBuilder[STR_CREATED_AT] = chrono::formatIsoDateTime(task.createdAt);
                    taskBuilder[STR_UPDATED_AT] = chrono::formatIsoDateTime(task.updatedAt);
                    taskBuilder[STR_ORIGINAL_TASK] = json::Verbatim(task.originalTaskJson);
                };
            }
        };
        root[STR_META] = [&](json::ObjectBuilder meta) {
            meta[STR_TOTAL] = result.total;
            meta[STR_OFFSET] = result.offset;
            meta[STR_LIMIT] = result.limit;
        };
    };
    return builder.str();
}

} // namespace maps::wiki
