#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/context.h>
#include <maps/wikimap/mapspro/services/editor/src/tablevalues.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/object.h>

#include <yandex/maps/wiki/common/format_type.h>
#include <maps/libs/json/include/value.h>

#include <string>
#include <vector>

namespace maps {
namespace wiki {

class JsonParser
{
public:
    typedef json::Value ValueType;

    static TOIds objectIdSet(const json::Value& jsonIds);
    static std::vector<TOid> objectIdVector(const json::Value& jsonIds);

    static Geom readObjectGeometry(const json::Value& jsonObject);
    static UUID readObjectUUID(const json::Value& jsonObject);
    static TOid readObjectId(const json::Value& jsonObject);
    static TRevisionId readObjectRevision(const json::Value& jsonObject);
    static std::string readObjectCategory(const json::Value& jsonObject);
    static boost::optional<std::string> readObjectRichContent(const json::Value& jsonObject);
    static StringMultiMap readObjectAttributes(const json::Value& jsonObject);
    static TableAttributesValues readObjectTableAttributes(const json::Value& jsonObject);
    static ObjectEditContextPtr readObjectEditContext(const json::Value& jsonObject);
};

} // namespace wiki
} // namespace maps
