#include "objects_query_route_diff_parser.h"

#include "common.h"
#include "json_parser.h"
#include "thread_stop_sequence_parser.h"

#include <maps/wikimap/mapspro/services/editor/src/exception.h>


namespace maps {
namespace wiki {

void ObjectsQueryRouteDiffParser::parse(
        common::FormatType formatType,
        const std::string& requestBody)
{
    if (formatType == common::FormatType::XML) {
        UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryRouteDiff");
    }

    parseJson(requestBody);
}

void ObjectsQueryRouteDiffParser::parseJson(const std::string& requestBody)
{
    const auto json = json::Value::fromString(requestBody);

    const auto& revisionId = json[STR_REVISION_ID];
    if (revisionId.exists()) {
        revisionId_ = boost::lexical_cast<TRevisionId>(revisionId.toString());
    }
    categoryId_ = json[STR_CATEGORY_ID].toString();

    const auto& elementsDiff = json[STR_ELEMENTS_DIFF];

    const auto& addElementIds = elementsDiff[STR_ADD];
    if (addElementIds.exists()) {
        addElementIds_ = JsonParser::objectIdSet(addElementIds);
    }

    const auto& removeElementIds = elementsDiff[STR_REMOVE];
    if (removeElementIds.exists()) {
        removeElementIds_ = JsonParser::objectIdSet(removeElementIds);
    }

    threadStopSequence_ = parseThreadStopSequence(json[STR_THREAD_STOPS]);
    fromThreadStopIdx_ = json[STR_FROM_THREAD_STOP_IDX].as<size_t>();
    toThreadStopIdx_ = json[STR_TO_THREAD_STOP_IDX].as<size_t>();
}

const TRevisionId& ObjectsQueryRouteDiffParser::revisionId() const { return revisionId_; }

const std::string& ObjectsQueryRouteDiffParser::categoryId() const { return categoryId_; }

const TOIds& ObjectsQueryRouteDiffParser::addElementIds() const { return addElementIds_; }

const TOIds& ObjectsQueryRouteDiffParser::removeElementIds() const { return removeElementIds_; }

const ThreadStopSequence& ObjectsQueryRouteDiffParser::threadStopSequence() const { return threadStopSequence_; }

size_t ObjectsQueryRouteDiffParser::fromThreadStopIdx() const { return fromThreadStopIdx_; }

size_t ObjectsQueryRouteDiffParser::toThreadStopIdx() const { return toThreadStopIdx_; }

} // namespace wiki
} // namespace maps
