#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/actions/routing/thread_stop.h>

#include <yandex/maps/wiki/common/format_type.h>
#include <yandex/maps/wiki/routing/stop.h>

#include <boost/optional.hpp>

#include <string>
#include <vector>


namespace maps {
namespace wiki {

class ObjectsQueryRouteDiffParser {

public:
    void parse(common::FormatType formatType, const std::string& requestBody);

    // empty in case of new thread
    const TRevisionId& revisionId() const;
    const std::string& categoryId() const;

    const TOIds& addElementIds() const;
    const TOIds& removeElementIds() const;

    const ThreadStopSequence& threadStopSequence() const;
    size_t fromThreadStopIdx() const;
    size_t toThreadStopIdx() const;

private:
    void parseJson(const std::string& requestBody);

    TRevisionId revisionId_;
    std::string categoryId_;

    TOIds addElementIds_;
    TOIds removeElementIds_;

    ThreadStopSequence threadStopSequence_;
    size_t fromThreadStopIdx_;
    size_t toThreadStopIdx_;
};

} // namespace wiki
} // namespace maps
