#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include "common.h"

namespace maps {
namespace wiki {

struct RelativesDiffRevisions
{
    RevisionIds added;
    RevisionIds removed;
};

typedef std::unordered_map<std::string, RelativesDiffRevisions> RelativesDiffRevisionsByRole;
typedef std::unordered_map<std::string, RevisionIds> RelativesToSetRevisionsByRole;

class ObjectsUpdateRelationsParser
{
public:
    void parse(const std::string& requestBody);

    const RevisionIds& objectsRevisionsToUpdate() const
    { return objectsRevisionsToUpdate_; }
    const RelativesDiffRevisionsByRole& mastersDiff() const
    { return mastersDiff_; }
    const RelativesDiffRevisionsByRole& slavesDiff() const
    { return slavesDiff_; }

    const RelativesToSetRevisionsByRole& mastersToSet() const
    { return mastersToSet_; }
    const RelativesToSetRevisionsByRole& slavesToSet() const
    { return slavesToSet_; }

private:
    RevisionIds objectsRevisionsToUpdate_;
    RelativesDiffRevisionsByRole mastersDiff_;
    RelativesDiffRevisionsByRole slavesDiff_;
    RelativesToSetRevisionsByRole mastersToSet_;
    RelativesToSetRevisionsByRole slavesToSet_;
};

} // namespace wiki
} // namespace maps
