#pragma once

#include "xml_parser.h"
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class RequestData
{
public:
    enum class VersionCheckPolicy {
        Enable,
        Optional
    };
    RequestData() : versionCheckPolicy_(VersionCheckPolicy::Enable) {}
    explicit RequestData(VersionCheckPolicy policy) : versionCheckPolicy_(policy) {}
    const std::vector<TOid>& oids() const { return oids_; }

protected:
    void parse (common::FormatType format, const std::string& body, ObjectsCache& cache);
    void parseJson(const std::string& json, ObjectsCache& cache);
    void parseXml(const std::string& xml, ObjectsCache& cache);
    virtual void parseContextDataJson(const json::Value& contextObject, ObjectsCache& cache) = 0;
    virtual void parseContextDataXml(const maps::xml3::Node& contextNode, ObjectsCache& cache) = 0;

private:
    std::vector<TOid> oids_;
    VersionCheckPolicy versionCheckPolicy_;
};

}
}
