#pragma once

#include <maps/wikimap/mapspro/services/editor/src/object_update_data.h>
#include <maps/wikimap/mapspro/services/editor/src/context.h>
#include <yandex/maps/wiki/common/format_type.h>

namespace maps {
namespace wiki {

class ObjectsCache;

enum class AttributeErrorPolicy
{
    Fail,
    EmptyResult
};

class SaveObjectParser
{
public:
    void parse(
        common::FormatType formatType,
        const std::string& requestBody,
        AttributeErrorPolicy attributeErrorPolicy = AttributeErrorPolicy::Fail);

    const ObjectsUpdateDataCollection& objects() const { return objects_; }
    const ObjectsEditContextsPtrMap& editContexts() const { return editContexts_; }

private:
    ObjectsUpdateDataCollection objects_;
    ObjectsEditContextsPtrMap editContexts_;
};

} // namespace wiki
} // namespace maps
