#include "thread_stop_sequence_parser.h"

#include "common.h"
#include "json_parser.h"

#include <maps/wikimap/mapspro/services/editor/src/utils.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/categories_strings.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {

namespace {

TOid readStopId(const json::Value& threadStopJson)
{
    const auto& stopJson = threadStopJson[STR_MASTERS] \
            [ROLE_ASSIGNED_THREAD_STOP] \
            [STR_DIFF] \
            [STR_ADDED] \
            [0]; \

    return JsonParser::readObjectId(stopJson);
}

} // namespace

ThreadStopSequence parseThreadStopSequence(const json::Value& threadStopSequenceJson)
{
    ThreadStopVector threadStops;

    for (const auto& threadStopJson: threadStopSequenceJson) {
        threadStops.emplace_back(
            JsonParser::readObjectId(threadStopJson),
            readStopId(threadStopJson),
            JsonParser::readObjectAttributes(threadStopJson)
        );
    }

    return ThreadStopSequence(std::move(threadStops));
}

} // namespace wiki
} // namespace maps
