#pragma once

#include <maps/wikimap/mapspro/services/editor/src/actions/tile/tile_object.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <yandex/maps/wiki/configs/editor/category_template.h>
#include <yandex/maps/wiki/configs/editor/interactivity.h>
#include <map>
#include <vector>

namespace maps::wiki {

using OrderedTileObjects = std::map<TZOrder, std::vector<const TileObject*>>;

template <typename TileObjects>
OrderedTileObjects sortTileObjects(const TileObjects& tileObjects)
{
    OrderedTileObjects ordered;

    const auto* editor = cfg()->editor();
    const auto& categories = editor->categories();

    for (const auto& objectPtr : tileObjects) {
        const auto& catTmpl = categories[objectPtr->categoryId()].categoryTemplate();
        ordered[
            editor->interactivity(catTmpl.interactivityId()).hotspotZOrder()
        ].push_back(objectPtr.get());
    }

    return ordered;
}


} // namespace maps::wiki
