#include "title.h"

namespace maps::wiki {

template<>
std::string attrValue(const views::ViewObject* obj, const std::string& valueId)
{
    const auto& attrs = obj->domainAttrs();
    const auto it = attrs.find(valueId);
    return it == attrs.end()
        ? std::string()
        : it->second;
}

template <>
std::string title<views::ViewObject>(const views::ViewObject* obj)
{
    return obj->screenLabel().empty()
        ? objNiceLabel(obj)
        : obj->screenLabel();
}

} // namespace maps::wiki
