#pragma once

#include "maps/wikimap/mapspro/services/editor/src/format.h"
#include "maps/wikimap/mapspro/services/editor/src/srv_attrs/generic.h"
#include "maps/wikimap/mapspro/services/editor/src/views/view_object.h"

#include <string>
#include <type_traits>

namespace maps::wiki {

class GeoObject;

template<typename> struct Void { typedef void type; };

template<typename T, typename Sfinae = void>
struct HasAttributes: std::false_type {};

template<typename T>
struct HasAttributes<
        T
        , typename Void<
            decltype( std::declval<const T*>()->attributes() )
        >::type
    >: std::true_type {};

template<typename ObjectInfo>
std::string attrValue(const ObjectInfo* obj, const std::string& valueId)
{
    return obj->attributes().value(valueId);
}

template<>
std::string attrValue(const views::ViewObject* obj, const std::string& valueId);

template<typename ObjectInfo>
std::string objNiceLabel(const ObjectInfo* obj)
{
    if (obj->categoryId() == CATEGORY_AOI) {
        const auto& aoiName = attrValue<ObjectInfo>(obj, ATTR_AOI_NAME);
        if (!aoiName.empty()) {
            return aoiName;
        }
    }

    const auto& ftTypeDef = srv_attrs::ftTypeAttrDefForCategory(obj->categoryId());
    if (ftTypeDef) {
        return valueLabel(ftTypeDef->id(), attrValue<ObjectInfo>(obj, ftTypeDef->id()));
    }

    const auto& nameDef = srv_attrs::plainNameAttrDefForCategory(obj->categoryId());
    if (nameDef) {
        const auto name = attrValue<ObjectInfo>(obj, nameDef->id());
        if (!name.empty()) {
            return name;
        }
    }

    const auto& enumTypeAttrDef =
        srv_attrs::enumeratedTypeAttrDefForCategory(obj->categoryId());
    if (enumTypeAttrDef) {
        return valueLabel(
            enumTypeAttrDef->id(),
            attrValue<ObjectInfo>(obj, enumTypeAttrDef->id()));
    }

    return categoryLabel(obj->categoryId());
}

template <typename ObjectInfo>
class ObjectWithAttributesLabelGetter
{
public:
    static std::string objNiceLabelBuilder(const ObjectInfo* obj)
    {
        return objNiceLabel<ObjectInfo>(obj);
    }
};

template <typename ObjectInfo>
class CategoryLabelGetter
{
public:
    static std::string objNiceLabelBuilder(const ObjectInfo* obj)
    {
        return categoryLabel(obj->categoryId());
    }
};

template <typename  ObjectInfo>
std::string title(const ObjectInfo* obj)
{
    typedef typename std::conditional<HasAttributes<ObjectInfo>::value,
            ObjectWithAttributesLabelGetter<ObjectInfo>,
            CategoryLabelGetter<ObjectInfo>>::type LabelGetter;
    return obj->screenLabel().empty()
        ? LabelGetter::objNiceLabelBuilder(obj)
        : obj->screenLabel();
}

template <>
std::string title<views::ViewObject>(const views::ViewObject* obj);

} // namespace maps::wiki
