#pragma once

#include "maps/wikimap/mapspro/services/editor/src/object_update_data.h"
#include "maps/wikimap/mapspro/services/editor/src/configs/config.h"

#include <yandex/maps/wiki/configs/editor/categories.h>

namespace maps {
namespace wiki {

// Topological objects update data for CreateIntersections

class TopoObjectData
{
public:
    TopoObjectData() = delete;

    TopoObjectData(
            UniqueId id,
            TRevisionId revId,
            std::string categoryId,
            Geom geom)
        : id_(id)
        , revisionId_(revId)
        , categoryId_(std::move(categoryId))
        , geom_(std::move(geom))
    {
        WIKI_REQUIRE(
            cfg()->editor()->categories().defined(categoryId_),
            ERR_BAD_DATA,
            "Unknown category: " << categoryId_);
        WIKI_REQUIRE(
            !geom_.isNull(),
            ERR_BAD_DATA,
            "No geom set for topological object, id " << id_);
    }

    operator const UniqueId& () const { return id_; }

    const UniqueId& id() const { return id_; }
    TRevisionId revision() const { return revisionId_; }
    const std::string& categoryId() const { return categoryId_; }
    const Geom& geometry() const { return geom_; }

private:
    UniqueId id_;
    TRevisionId revisionId_;
    std::string categoryId_;
    Geom geom_;
};

typedef UniqueList<TopoObjectData, UniqueId> TopoObjectDataCollection;

} // namespace wiki
} // namespace maps
