#pragma once

#include "common.h"
#include "formatter.h"

namespace maps {
namespace wiki {

class XMLFormatter: public Formatter
{
public:
    XMLFormatter(std::unique_ptr<FormatterContext>&& context)
        : Formatter(std::move(context)) {}

    virtual std::string formatException(const maps::Exception& ex, bool withBacktrace);

    virtual std::string operator ()(const ResultType<SaveObject>& result);

    virtual std::string operator ()(const ResultType<CreateIntersections>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "CreateIntersections"); }

    virtual std::string operator ()(const ResultType<CloneObject>& result);

    virtual std::string operator ()(const ResultType<GetTopology>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetTopology"); }

    virtual std::string operator ()(const ResultType<ToolsPedestrianPoints>& result);
    virtual std::string operator ()(const ResultType<ToolsSavePedestrianPoints>& result);
    virtual std::string operator ()(const ResultType<ToolsLoadPedestrianPoints>& result);

    virtual std::string operator ()(const ResultType<ObjectsUpdateAttributes>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateAttributesMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateAttributesMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsUpdateState>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateStateMeta>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateStateMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsUpdateMove>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateMoveMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateMoveMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsUpdateSyncGeometry>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateSyncGeometryMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateSyncGeometryMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsUpdateRelation>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateUnion>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateUnionMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateUnionMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsUpdateMerge>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateSnap>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateSnapMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateSnapMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsCleanupRelations>& result);
    virtual std::string operator ()(const ResultType<ObjectsUpdateRelations>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateRelations"); }
    virtual std::string operator ()(const ResultType<ObjectsUpdateRelationsMeta>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsUpdateRelationsMeta"); }
    virtual std::string operator ()(const ResultType<GetObject>& result);
    virtual std::string operator ()(const ResultType<GetHistory>& result);
    virtual std::string operator ()(const ResultType<GetObjectsByTile>& result);
    virtual std::string operator ()(const ResultType<ObjectsQueryLasso>& result);
    virtual std::string operator ()(const ResultType<ObjectsQueryLassoMeta>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryLassoMeta"); }
    virtual std::string operator ()(const ResultType<ObjectsQueryTitle>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryTitle"); }
    virtual std::string operator ()(const ResultType<ObjectsQueryPoiBusinessId>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryPoiBusinessId"); }
    virtual std::string operator ()(const ResultType<ObjectsQueryIds>& result);
    virtual std::string operator ()(const ResultType<ObjectsQueryCategory>& result);
    virtual std::string operator ()(const ResultType<ObjectsQueryPath>& result);
    virtual std::string operator ()(const ResultType<ObjectsQueryFilter>& result);
    virtual std::string operator ()(const ResultType<GetAsyncResult>& result);
    virtual std::string operator ()(const ResultType<GetSlaveInfos>& result);
    virtual std::string operator ()(const ResultType<GetLayers>& result);
    virtual std::string operator ()(const ResultType<GetLayers2>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetLayers2"); }
    virtual std::string operator ()(const ResultType<GetFilters>& result);
    virtual std::string operator ()(const ResultType<SaveFilter>& result);
    virtual std::string operator ()(const ResultType<DeleteFilter>& result);
    virtual std::string operator ()(const ResultType<GetFilterExpression>& result);
    virtual std::string operator ()(const ResultType<SaveExpression>& result);
    virtual std::string operator ()(const ResultType<GetSuggest>& result);
    virtual std::string operator ()(const ResultType<GetBranches>& result);
    virtual std::string operator ()(const ResultType<SaveBranchType>& result);
    virtual std::string operator ()(const ResultType<SaveBranchState>& result);

    virtual std::string operator ()(const ResultType<GetValidationExclusions>& result);
    virtual std::string operator ()(const ResultType<SaveValidationExclusion>& result);
    virtual std::string operator ()(const ResultType<ViewValidationExclusion>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ViewValidationExclusion"); }

    virtual std::string operator ()(const ResultType<AsyncBaseController>& result);
    virtual std::string operator ()(const ResultType<GetGeoLocks>& result);
    virtual std::string operator ()(const ResultType<GetCommitDiff>& result);
    virtual std::string operator ()(const ResultType<GetCommitGeomDiff>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetCommitGeomDiff"); }
    virtual std::string operator ()(const ResultType<GetBranchDiff>& result);
    virtual std::string operator ()(const ResultType<CreateToken>& result);
    virtual std::string operator ()(const ResultType<GetRegularSocialFeedMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetRegularSocialFeedMeta"); }
    virtual std::string operator ()(const ResultType<GetSocialFeed>& result);
    virtual std::string operator ()(const ResultType<GetSocialModerationTaskByCommit>& result);

    virtual std::string operator ()(const ResultType<GetSocialSubscriptions>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialSubscriptions"); }

    virtual std::string operator ()(const ResultType<SocialModerationRegions>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationRegions"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksAcquire>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksAcquire"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksAcquireBlocking>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksAcquireBlocking"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksRelease>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksRelease"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksResolve>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksResolve"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksClose>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksClose"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksDefer>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksDefer"); }

    virtual std::string operator ()(const ResultType<SocialModerationTasksStat>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationTasksStat"); }

    virtual std::string operator ()(const ResultType<GetSocialModerationTask>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialModerationTask"); }

    virtual std::string operator ()(const ResultType<GetSocialModerationStat>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialModerationStat"); }

    virtual std::string operator ()(const ResultType<GetSocialEvent>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialEvent"); }

    virtual std::string operator ()(const ResultType<GetSocialModerationTasks>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialModerationTasks"); }

    virtual std::string operator ()(const ResultType<SocialModerationDashboard>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationDashboard"); }

    virtual std::string operator ()(const ResultType<SocialModerationDashboardMeta>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "SocialModerationDashboardMeta"); }

    virtual std::string operator ()(const ResultType<GetSocialFeedbackTaskHistory>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialFeedbackTaskHistory"); }

    virtual std::string operator ()(const ResultType<GetSocialFeedbackTaskStat>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSocialFeedbackTaskStat"); }

    virtual std::string operator ()(const ResultType<CreateSpravTask>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "CreateSpravTask"); }

    virtual std::string operator ()(const ResultType<GetSpravTasks>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetSpravTasks"); }

    virtual std::string operator ()(const ResultType<GetCommentsFeed>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetCommentsFeed"); }

    virtual std::string operator ()(const ResultType<GetCommentsStat>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetCommentsStat"); }

    virtual std::string operator ()(const ResultType<ClearUserComments>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ClearUserComments"); }

    virtual std::string operator ()(const ResultType<CommentsCreate>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "CommentsCreate"); }

    virtual std::string operator ()(const ResultType<CommentsDelete>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "CommentsDelete"); }

    virtual std::string operator ()(const ResultType<GetCommit>& result);

    virtual std::string operator ()(const ResultType<CommitsApprove>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "CommitsApprove"); }

    virtual std::string operator ()(const ResultType<CommitsRevert>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "CommitsRevert"); }

    virtual std::string operator ()(const ResultType<GetDependentCommits>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetDependentCommits"); }

    virtual std::string operator ()(const ResultType<ObjectsQueryJunction>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryJunction"); }

    virtual std::string operator ()(const ResultType<ObjectsQueryRouteDiff>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetRouteDiff"); }

    virtual std::string operator ()(const ResultType<ObjectsQueryPoiConflicts>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryPoiConflicts"); }

    virtual std::string operator ()(const ResultType<ObjectsQueryPoisConflicts>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryPoisConflicts"); }
    virtual std::string operator ()(const ResultType<ObjectsQueryPoisConflictsMeta>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ObjectsQueryPoisConflictsMeta"); }

    virtual std::string operator ()(const ResultType<ToolsResolvePoisConflicts>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ToolsResolvePoisConflicts"); }
    virtual std::string operator ()(const ResultType<ToolsResolvePoisConflictsMeta>&)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "ToolsResolvePoisConflictsMeta"); }

    virtual std::string operator ()(const ResultType<GetRouteTime>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "GetRouteTime"); }

    virtual std::string operator ()(const ResultType<PointToBld>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "PointToBld"); }

    virtual std::string operator ()(const ResultType<BusinessPhotos>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "BusinessPhotos"); }

    virtual std::string operator ()(const ResultType<DistributeFlats>& /*result*/)
    { UNSUPPORTED_FORMAT(common::FormatType::XML, "DistributeFlats"); }

    virtual std::string operator ()(const AsyncTaskResult& result);
};

class XmlOutputStream : public std::ostringstream
{
public:
    XmlOutputStream()
    {
        precision(GEODETIC_GEOM_PRECISION);
        *this << std::fixed;
    }
};

} // namespace wiki
} // namespace maps
