#pragma once

#include <maps/wikimap/mapspro/services/editor/src/tablevalues.h>
#include <maps/wikimap/mapspro/services/editor/src/context.h>
#include "xml_writer.h"

#include <maps/libs/xml/include/xml.h>

namespace maps {
namespace wiki {

class XmlWriter;
class ObjectsCache;

class XmlParser
{
public:
    typedef maps::xml3::Node ValueType;

    static maps::xml3::Nodes objectNodes(maps::xml3::Doc& doc);

    static Geom readObjectGeometry(const maps::xml3::Node& objNode);
    static UUID readObjectUUID(const maps::xml3::Node& objNode);
    static TRevisionId readObjectRevision(const maps::xml3::Node& objNode);
    static std::string readObjectCategory(const maps::xml3::Node& objNode);
    static boost::optional<std::string> readObjectRichContent(const maps::xml3::Node& objNode);
    static StringMultiMap readObjectAttributes(const maps::xml3::Node& objNode);
    static TableAttributesValues readObjectTableAttributes(const maps::xml3::Node& objNode);
    static ObjectEditContextPtr readObjectEditContext(const maps::xml3::Node& objNode);
};

void registerNamespaces(xml3::Doc& doc);

} // namespace wiki
} // namespace maps
