#pragma once

#include "common.h"
#include "check_permissions.h"

#include <yandex/maps/wiki/diffalert/message.h>
#include <yandex/maps/wiki/revision/filters.h>
#include <yandex/maps/wiki/social/gateway.h>
#include <yandex/maps/wiki/social/task.h>
#include <geos/geom/Envelope.h>

namespace maps {
namespace wiki {

class BranchContext;

revision::filters::ProxyFilterExpr existingAoiFilter(const TOIds& aoiIds);

TOIds getAoiIds(
    const BranchContext& branchCtx,
    const std::vector<ObjectPtr>& objects,
    const geos::geom::Envelope& envelope);

TOIds getImportantRegionIds(
    const BranchContext& branchCtx,
    const std::vector<ObjectPtr>& objects,
    const geos::geom::Envelope& envelope);

TOIds getPublishRegionIds(
    const BranchContext& branchCtx,
    const std::vector<ObjectPtr>& objects,
    const geos::geom::Envelope& envelope);

bool isCommitInImportantRegion(
    const BranchContext& branchCtx,
    const std::string& categoryId,
    const std::vector<ObjectPtr>& geomDiffObjects,
    const geos::geom::Envelope& envelope);
bool isCommitInImportantRegion(
    const BranchContext& branchCtx,
    const std::string& categoryId,
    const geolib3::BoundingBox& bbox);

bool isCommitWithBigArea(
    const std::string& categoryId,
    const std::vector<diffalert::Message>& diffalertMessages);
bool isCommitWithBigArea(
    const std::string& categoryId,
    const social::Gateway& socialGateway,
    TId taskId);

social::EventAlerts
loadPermittedAlerts(
    social::TId taskId,
    const social::Gateway& socialGateway,
    CheckPermissions& permissionsChecker);

std::map<social::TId, social::EventAlerts>
fillAlertsByTaskId(
    const social::Tasks& tasks,
    social::Gateway& socialGw,
    CheckPermissions& permissionsChecker);

} // namespace wiki
} // namespace maps
