#include "sprav_task.h"

#include <maps/libs/json/include/builder.h>

using namespace std::string_literals;

namespace maps::wiki {
namespace {
const auto TASK_ID = "task_id";
const auto SPRAV_TASK_ID = "sprav_task_id";
const auto CREATED_AT = "created_at"s;
const auto UPDATED_AT = "updated_at"s;
const auto OBJECT_ID = "object_id"s;
const auto PERMALINK = "permalink"s;
const auto SPRAV_STATUS = "sprav_status"s;
const auto ORIGINAL_TASK = "original_task"s;
const auto CREATED_BY = "created_by"s;

const auto PERMALINK_IN_ORIGINAL_TASK = "object_id"s;

} // namespace

constexpr enum_io::Representations<SpravTask::Status> SPRAV_TASK_STATUS_ENUM_REPRESENTATION {
    {SpravTask::Status::NotSubmitted, "not_submitted"},
    {SpravTask::Status::New, "new"},
    {SpravTask::Status::InProgress, "in_progress"},
    {SpravTask::Status::Accepted, "accepted"},
    {SpravTask::Status::Rejected, "rejected"},
    {SpravTask::Status::Published, "published"}
};

DEFINE_ENUM_IO(SpravTask::Status, SPRAV_TASK_STATUS_ENUM_REPRESENTATION);

SpravTask::SpravTask(const pqxx::row& row)
{
    id = row[TASK_ID].as<TOid>();
    if (!row[SPRAV_TASK_ID].is_null()) {
        spravTaskId = row[SPRAV_TASK_ID].c_str();
    }
    objectId = row[OBJECT_ID].as<TOid>();
    if (!row[PERMALINK].is_null()) {
        permalink = row[PERMALINK].as<TOid>();
    } else {
        permalink = 0;
    }
    status = boost::lexical_cast<SpravTask::Status>(row[SPRAV_STATUS].c_str());
    createdBy = row[CREATED_BY].as<TUid>();
    createdAt = chrono::parseSqlDateTime(row[CREATED_AT].c_str());
    updatedAt = chrono::parseSqlDateTime(row[UPDATED_AT].c_str());
    originalTaskJson = row[ORIGINAL_TASK].c_str();
}

OriginalTask
OriginalTask::fromJsonString(const std::string& jsonString)
{
    OriginalTask originalTask;
    auto parsed = json::Value::fromString(jsonString);
    for (const auto& field : parsed.fields()) {
        if (field != PERMALINK_IN_ORIGINAL_TASK) {
            originalTask.values_.emplace(field, parsed[field]);
        } else {
            originalTask.permalink_ =
                boost::lexical_cast<TOid>(parsed[PERMALINK_IN_ORIGINAL_TASK].toString());
        }

    }
    return originalTask;
}

std::string
OriginalTask::toJsonString() const
{
    json::Builder builder;
    builder << [&](json::ObjectBuilder object) {
        object[PERMALINK_IN_ORIGINAL_TASK] = std::to_string(permalink_);
        for (const auto& [field, value] : values_) {
            object[field] << value;
        }
    };
    return builder.str();
}

}//namespace maps::wiki
