#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <maps/libs/json/include/value.h>
#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/chrono/include/time_point.h>

using namespace std::string_literals;

namespace maps::wiki {

const auto SPRAV_TASKS_TABLE = "sprav.tasks"s;

class OriginalTask
{
public:
    friend struct SpravTask;
    static OriginalTask fromJsonString(const std::string& jsonString);
    std::string toJsonString() const;
    TOid permalink() { return permalink_; }
    void setPermalink(TOid newPermalink) { permalink_ = newPermalink; }

private:
    std::unordered_map<std::string, json::Value> values_;
    TOid permalink_ = 0;
};

struct SpravTask
{
public:
    explicit SpravTask(const pqxx::row& row);
    enum class Status {
        NotSubmitted,
        New,
        InProgress,
        Accepted,
        Rejected,
        Published
    };
    TOid id = 0;
    TOid objectId = 0;
    TOid permalink = 0;
    std::string spravTaskId;
    Status status = Status::NotSubmitted;

    chrono::TimePoint createdAt;
    chrono::TimePoint updatedAt;
    TUid createdBy = 0;
    std::string originalTaskJson;
};

DECLARE_ENUM_IO(SpravTask::Status);

}//namespace maps::wiki

