WITH line_AND_point AS (
SELECT DISTINCT l.geometry_id AS lg_id, j.geometry_id AS jg_id, j.object_id AS jid FROM revision.object_revision_relation r, revision.object_revision_with_geometry l, revision.object_revision_with_geometry j,
revision.geometry lg, revision.geometry jg, revision.attributes ra, revision.commit cl, revision.commit cj,  revision.commit cr
WHERE r.master_object_id=l.object_id AND r.slave_object_id=j.object_id AND r.next_commit_id = 0 AND l.next_commit_id=0 AND j.next_commit_id = 0
AND NOT r.deleted AND NOT l.deleted AND NOT j.deleted
AND lg.id=l.geometry_id AND jg.id=j.geometry_id
AND r.attributes_id = ra.id AND (ra.contents @> hstORe('rel:role', 'start') OR ra.contents @> hstORe('rel:role', 'end'))
AND NOT st_dwithin(lg.contents, jg.contents, 0.0001)
AND cl.id=l.commit_id AND cj.id=j.commit_id AND cl.trunk AND cj.trunk AND cr.trunk AND cr.id=r.commit_id)
UPDATE revision.geometry g2 SET contents = ST_ClosestPoint(g1.contents, g2.contents) FROM revision.geometry g1, line_AND_point WHERE lg_id = g1.id AND jg_id=g2.id RETURNING jid
