SET search_path=public;

CREATE OR REPLACE FUNCTION revision_attributes_rename_key(in oldkey text, in newkey text) RETURNS void AS $$
BEGIN
UPDATE revision.attributes SET contents = delete(contents, oldkey) || hstore(newkey, contents -> oldkey) WHERE contents ? oldkey;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION revision_attributes_replace_value(in akey text, in oldvalue text, in newvalue text) RETURNS void AS $$
BEGIN
UPDATE revision.attributes SET contents = delete(contents, akey) || hstore(akey, newvalue) WHERE contents -> akey = oldvalue;
END;
$$ LANGUAGE plpgsql;


SELECT  revision_attributes_rename_key('hydro_river_fc:is_interior', 'hydro_fc:is_interior'),
        revision_attributes_rename_key('hydro_river_el:f_zlev', 'hydro_el:f_zlev'),
        revision_attributes_rename_key('hydro_river_el:t_zlev', 'hydro_el:t_zlev'),
        revision_attributes_rename_key('cat:hydro_river_jc', 'cat:hydro_jc'),
        revision_attributes_rename_key('cat:hydro_river_el', 'cat:hydro_el'),
        revision_attributes_rename_key('cat:hydro_river_fc', 'cat:hydro_fc'),
        revision_attributes_rename_key('hydro_river_nm:lang', 'hydro_nm:lang'),
        revision_attributes_rename_key('hydro_river_nm:name', 'hydro_nm:name'),
        revision_attributes_rename_key('cat:hydro_river_nm', 'cat:hydro_nm');

SELECT  revision_attributes_replace_value('rel:master', 'hydro_river_el', 'hydro_el'),
        revision_attributes_replace_value('rel:master', 'hydro_river_fc', 'hydro_fc'),
        revision_attributes_replace_value('rel:slave', 'hydro_river_nm', 'hydro_nm'),
        revision_attributes_replace_value('rel:slave', 'hydro_river_fc', 'hydro_fc'),
        revision_attributes_replace_value('rel:slave', 'hydro_river_el', 'hydro_el'),
        revision_attributes_replace_value('rel:slave', 'hydro_river_jc', 'hydro_jc');

DROP FUNCTION revision_attributes_rename_key(in oldkey text, in newkey text);
DROP FUNCTION revision_attributes_replace_value(in akey text, in oldvalue text, in newvalue text);

