BEGIN TRANSACTION;
SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

CREATE SCHEMA vrevisions_trunk;

ALTER SCHEMA vrevisions_trunk OWNER TO mapadmin;

SET search_path = vrevisions_trunk, pg_catalog;

CREATE FUNCTION objects_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF ( NEW.zmin >= 16) THEN
        INSERT INTO objects_a16 VALUES (NEW.*);    
    ELSIF ( NEW.zmin >= 14 and NEW.zmin < 16 ) THEN
        INSERT INTO objects_a14 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 12 and NEW.zmin < 14 ) THEN
        INSERT INTO objects_a12 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 10 and NEW.zmin < 12 ) THEN
        INSERT INTO objects_a10 VALUES (NEW.*);
    ELSIF ( NEW.zmin >= 8 and NEW.zmin < 10 ) THEN
        INSERT INTO objects_a8 VALUES (NEW.*);
    ELSIF ( NEW.zmin <= 7) THEN
        INSERT INTO objects_a7 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION 'Zoom out of range.  Fix the objects_insert_trigger() function!';
    END IF;        
    RETURN NULL;
END;
$$;

ALTER FUNCTION objects_insert_trigger() OWNER TO mapadmin;

CREATE FUNCTION objects_l_insert_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    IF ( NEW.zmin >= 16) THEN
        INSERT INTO objects_l16 VALUES (NEW.*);    
    ELSIF ( NEW.zmin >=13 and NEW.zmin < 16) THEN
        INSERT INTO objects_l13 VALUES (NEW.*);
    ELSIF ( NEW.zmin >=10 and NEW.zmin < 13) THEN
        INSERT INTO objects_l10 VALUES (NEW.*);    
    ELSIF ( NEW.zmin <= 9) THEN
        INSERT INTO objects_l9 VALUES (NEW.*);
    ELSE
        RAISE EXCEPTION 'Zoom out of range.  Fix the objects_insert_trigger() function!';    
    END IF;        
    RETURN NULL;
END;
$$;

ALTER FUNCTION objects_l_insert_trigger() OWNER TO mapadmin;

CREATE FUNCTION objects_l_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
        DELETE from objects_l where id = OLD.id;
        INSERT INTO objects_l VALUES (NEW.*);
        RETURN NULL;
END;
$$;

ALTER FUNCTION objects_l_update_trigger() OWNER TO mapadmin;

CREATE FUNCTION objects_update_trigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
        DELETE from objects_a where id = OLD.id;
        INSERT INTO objects_a VALUES (NEW.*);
        RETURN NULL;
END;
$$;

ALTER FUNCTION objects_update_trigger() OWNER TO mapadmin;

CREATE FUNCTION statistics_increment(attr character varying, val character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$BEGIN
    UPDATE statistics SET count = count + 1 WHERE attribute=attr AND value=val;
    IF found THEN
      RETURN;
    END IF;
    INSERT INTO statistics(attribute, value, count) VALUES (attr, val, 1);
END$$;


ALTER FUNCTION statistics_increment(attr character varying, val character varying) OWNER TO mapadmin;

CREATE FUNCTION statistics_increment_exception(category character varying, attr character varying, val character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$BEGIN
BEGIN    
    INSERT INTO statistics(category_id, attribute, value, count) VALUES (category, attr, val, 1);
    EXCEPTION WHEN unique_violation THEN
      UPDATE statistics SET count = count + 1 WHERE category_id=category AND attribute=attr AND value=val;
    END;
END$$;

ALTER FUNCTION statistics_increment_exception(category character varying, attr character varying, val character varying) OWNER TO mapadmin;

SET default_tablespace = '';

SET default_with_oids = false;

CREATE TABLE objects (
    id bigint NOT NULL,    
    commit_id bigint NOT NULL,
    the_geom public.geometry,
    zmin integer DEFAULT 0 NOT NULL,
    zmax integer,
    modified timestamp with time zone,
    domain_attrs public.hstore,
    service_attrs public.hstore,
    CONSTRAINT objects_commit_id_check CHECK (commit_id > 0)
);


ALTER TABLE objects OWNER TO postgres;

CREATE TABLE objects_a (
    area double precision NOT NULL,
    the_center public.geometry,
    icon_zmin integer DEFAULT 0
)
INHERITS (objects);

ALTER TABLE objects_a OWNER TO mapadmin;

CREATE TABLE objects_a10 (
    CONSTRAINT objects_a10_zmin_check CHECK (((zmin >= 10) AND (zmin < 12)))
)
INHERITS (objects_a);

ALTER TABLE objects_a10 OWNER TO mapadmin;

CREATE TABLE objects_a12 (
    CONSTRAINT objects_a12_zmin_check CHECK (((zmin >= 12) AND (zmin < 14)))
)
INHERITS (objects_a);


ALTER TABLE objects_a12 OWNER TO mapadmin;

CREATE TABLE objects_a14 (
    CONSTRAINT objects_a14_zmin_check CHECK (((zmin >= 14) AND (zmin < 16)))
)
INHERITS (objects_a);

ALTER TABLE objects_a14 OWNER TO mapadmin;

CREATE TABLE objects_a16 (
    CONSTRAINT objects_a16_zmin_check CHECK ((zmin >= 16))
)
INHERITS (objects_a);


ALTER TABLE objects_a16 OWNER TO mapadmin;

CREATE TABLE objects_a7 (
    CONSTRAINT objects_a7_zmin_check CHECK ((zmin <= 7))
)
INHERITS (objects_a);


ALTER TABLE objects_a7 OWNER TO mapadmin;

CREATE TABLE objects_a8 (
    CONSTRAINT objects_a8_zmin_check CHECK (((zmin >= 8) AND (zmin < 10)))
)
INHERITS (objects_a);

ALTER TABLE objects_a8 OWNER TO mapadmin;

CREATE TABLE objects_l (
    length double precision DEFAULT 0 NOT NULL,
)
INHERITS (objects);


ALTER TABLE objects_l OWNER TO mapadmin;

CREATE TABLE objects_l10 (
    CONSTRAINT objects_l10_zmin_check CHECK (((zmin >= 10) AND (zmin < 13)))
)
INHERITS (objects_l);

ALTER TABLE objects_l10 OWNER TO mapadmin;

CREATE TABLE objects_l13 (
    CONSTRAINT objects_l13_zmin_check CHECK (((zmin >= 13) AND (zmin < 16)))
)
INHERITS (objects_l);

ALTER TABLE objects_l13 OWNER TO mapadmin;

CREATE TABLE objects_l16 (
    CONSTRAINT objects_l16_zmin_check CHECK ((zmin >= 16))
)
INHERITS (objects_l);

ALTER TABLE objects_l16 OWNER TO mapadmin;

CREATE TABLE objects_l9 (
    CONSTRAINT objects_l9_zmin_check CHECK ((zmin <= 9))
)
INHERITS (objects_l);

ALTER TABLE objects_l9 OWNER TO mapadmin;

CREATE TABLE objects_p (
)
INHERITS (objects);

ALTER TABLE objects_p OWNER TO mapadmin;

CREATE TABLE objects_r (
    master_id bigint NOT NULL,
    slave_id bigint NOT NULL
)
INHERITS (objects);

ALTER TABLE objects_r OWNER TO mapadmin;

CREATE TABLE objects_c (    
)
INHERITS (objects);

CREATE TABLE statistics
(
  attribute text NOT NULL,
  value text NOT NULL,
  count integer NOT NULL DEFAULT 0,
  category_id text
)
WITH (
  OIDS=FALSE
);

ALTER TABLE statistics OWNER TO mapadmin;

ALTER TABLE objects_c OWNER TO mapadmin;

ALTER TABLE statistics OWNER TO mapadmin;

ALTER TABLE ONLY objects_a10
    ADD CONSTRAINT objects_a10_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_a12
    ADD CONSTRAINT objects_a12_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_a14
    ADD CONSTRAINT objects_a14_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_a16
    ADD CONSTRAINT objects_a16_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_a7
    ADD CONSTRAINT objects_a7_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_a8
    ADD CONSTRAINT objects_a8_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_a
    ADD CONSTRAINT objects_a_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_l10
    ADD CONSTRAINT objects_l10_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_l13
    ADD CONSTRAINT objects_l13_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_l16
    ADD CONSTRAINT objects_l16_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_l9
    ADD CONSTRAINT objects_l9_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_l
    ADD CONSTRAINT objects_l_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_p
    ADD CONSTRAINT objects_p_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects_c
    ADD CONSTRAINT objects_c_pkey PRIMARY KEY (id);

ALTER TABLE ONLY objects
    ADD CONSTRAINT objects_pkey PRIMARY KEY (id);

ALTER TABLE ONLY statistics
    ADD CONSTRAINT statistics_pkey PRIMARY KEY (attribute, value);

CREATE INDEX objects_a10_area_index ON objects_a10 USING btree (area);

CREATE INDEX objects_a10_attributes_gist ON objects_a10 USING gist (domain_attrs);

CREATE INDEX objects_a10_commit_id_index ON objects_a10 USING btree (commit_id);

CREATE INDEX objects_a10_the_center_index ON objects_a10 USING gist (the_center);

CREATE INDEX objects_a10_the_geom_index ON objects_a10 USING gist (the_geom);

CREATE INDEX objects_a10_zmax_index ON objects_a10 USING btree (zmax);

CREATE INDEX objects_a10_zmin_index ON objects_a10 USING btree (zmin);

CREATE INDEX objects_a12_area_index ON objects_a12 USING btree (area);

CREATE INDEX objects_a12_attributes_gist ON objects_a12 USING gist (domain_attrs);

CREATE INDEX objects_a12_commit_id_index ON objects_a12 USING btree (commit_id);

CREATE INDEX objects_a12_the_center_index ON objects_a12 USING gist (the_center);

CREATE INDEX objects_a12_the_geom_index ON objects_a12 USING gist (the_geom);

CREATE INDEX objects_a12_zmax_index ON objects_a12 USING btree (zmax);

CREATE INDEX objects_a12_zmin_index ON objects_a12 USING btree (zmin);

CREATE INDEX objects_a14_area_index ON objects_a14 USING btree (area);

CREATE INDEX objects_a14_attributes_gist ON objects_a14 USING gist (domain_attrs);

CREATE INDEX objects_a14_commit_id_index ON objects_a14 USING btree (commit_id);

CREATE INDEX objects_a14_the_center_index ON objects_a14 USING gist (the_center);

CREATE INDEX objects_a14_the_geom_index ON objects_a14 USING gist (the_geom);

CREATE INDEX objects_a14_zmax_index ON objects_a14 USING btree (zmax);

CREATE INDEX objects_a14_zmin_index ON objects_a14 USING btree (zmin);

CREATE INDEX objects_a16_area_index ON objects_a16 USING btree (area);

CREATE INDEX objects_a16_attributes_gist ON objects_a16 USING gist (domain_attrs);

CREATE INDEX objects_a16_commit_id_index ON objects_a16 USING btree (commit_id);

CREATE INDEX objects_a16_the_center_index ON objects_a16 USING gist (the_center);

CREATE INDEX objects_a16_the_geom_index ON objects_a16 USING gist (the_geom);

CREATE INDEX objects_a16_zmax_index ON objects_a16 USING btree (zmax);

CREATE INDEX objects_a16_zmin_index ON objects_a16 USING btree (zmin);

CREATE INDEX objects_a7_area_index ON objects_a7 USING btree (area);

CREATE INDEX objects_a7_attributes_gist ON objects_a7 USING gist (domain_attrs);

CREATE INDEX objects_a7_commit_id_index ON objects_a7 USING btree (commit_id);

CREATE INDEX objects_a7_the_center_index ON objects_a7 USING gist (the_center);

CREATE INDEX objects_a7_the_geom_index ON objects_a7 USING gist (the_geom);

CREATE INDEX objects_a7_zmax_index ON objects_a7 USING btree (zmax);

CREATE INDEX objects_a7_zmin_index ON objects_a7 USING btree (zmin);

CREATE INDEX objects_a8_area_index ON objects_a8 USING btree (area);

CREATE INDEX objects_a8_attributes_gist ON objects_a8 USING gist (domain_attrs);

CREATE INDEX objects_a8_commit_id_index ON objects_a8 USING btree (commit_id);

CREATE INDEX objects_a8_the_center_index ON objects_a8 USING gist (the_center);

CREATE INDEX objects_a8_the_geom_index ON objects_a8 USING gist (the_geom);

CREATE INDEX objects_a8_zmax_index ON objects_a8 USING btree (zmax);

CREATE INDEX objects_a8_zmin_index ON objects_a8 USING btree (zmin);

CREATE INDEX objects_a_area_index ON objects_a USING btree (area);

CREATE INDEX objects_a_attributes_gist ON objects_a USING gist (domain_attrs);

CREATE INDEX objects_a_commit_id_index ON objects_a USING btree (commit_id);

CREATE INDEX objects_a_icon_zmin_index ON objects_a USING btree (icon_zmin);

CREATE INDEX objects_a_the_center_index ON objects_a USING gist (the_center);

CREATE INDEX objects_a_the_geom_index ON objects_a USING gist (the_geom);

CREATE INDEX objects_a_zmax_index ON objects_a USING btree (zmax);

CREATE INDEX objects_a_zmin_index ON objects_a USING btree (zmin);

CREATE INDEX objects_attributes_gist ON objects USING gist (domain_attrs);

CREATE INDEX objects_commit_id_index ON objects USING btree (commit_id);

CREATE INDEX objects_l10_attributes_gist ON objects_l10 USING gist (domain_attrs);

CREATE INDEX objects_l10_commit_id_index ON objects_l10 USING btree (commit_id);

CREATE INDEX objects_l10_length_index ON objects_l10 USING btree (length);

CREATE INDEX objects_l10_the_geom_index ON objects_l10 USING gist (the_geom);

CREATE INDEX objects_l10_zmax_index ON objects_l10 USING btree (zmax);

CREATE INDEX objects_l10_zmin_index ON objects_l10 USING btree (zmin);

CREATE INDEX objects_l13_attributes_gist ON objects_l13 USING gist (domain_attrs);

CREATE INDEX objects_l13_commit_id_index ON objects_l13 USING btree (commit_id);

CREATE INDEX objects_l13_length_index ON objects_l13 USING btree (length);

CREATE INDEX objects_l13_the_geom_index ON objects_l13 USING gist (the_geom);

CREATE INDEX objects_l13_zmax_index ON objects_l13 USING btree (zmax);

CREATE INDEX objects_l13_zmin_index ON objects_l13 USING btree (zmin);

CREATE INDEX objects_l16_attributes_gist ON objects_l16 USING gist (domain_attrs);

CREATE INDEX objects_l16_commit_id_index ON objects_l16 USING btree (commit_id);

CREATE INDEX objects_l16_length_index ON objects_l16 USING btree (length);

CREATE INDEX objects_l16_the_geom_index ON objects_l16 USING gist (the_geom);

CREATE INDEX objects_l16_zmax_index ON objects_l16 USING btree (zmax);

CREATE INDEX objects_l16_zmin_index ON objects_l16 USING btree (zmin);

CREATE INDEX objects_l9_attributes_gist ON objects_l9 USING gist (domain_attrs);

CREATE INDEX objects_l9_commit_id_index ON objects_l9 USING btree (commit_id);

CREATE INDEX objects_l9_length_index ON objects_l9 USING btree (length);

CREATE INDEX objects_l9_the_geom_index ON objects_l9 USING gist (the_geom);

CREATE INDEX objects_l9_zmax_index ON objects_l9 USING btree (zmax);

CREATE INDEX objects_l9_zmin_index ON objects_l9 USING btree (zmin);

CREATE INDEX objects_l_attributes_gist ON objects_l USING gist (domain_attrs);

CREATE INDEX objects_l_commit_id_index ON objects_l USING btree (commit_id);

CREATE INDEX objects_l_length_index ON objects_l USING btree (length);

CREATE INDEX objects_l_the_geom_index ON objects_l USING gist (the_geom);

CREATE INDEX objects_l_zmax_index ON objects_l USING btree (zmax);

CREATE INDEX objects_l_zmin_index ON objects_l USING btree (zmin);

CREATE INDEX objects_p_attributes_gist ON objects_p USING gist (domain_attrs);

CREATE INDEX objects_p_commit_id_index ON objects_p USING btree (commit_id);

CREATE INDEX objects_p_the_geom_index ON objects_p USING gist (the_geom);

CREATE INDEX objects_p_zmax_index ON objects_p USING btree (zmax);

CREATE INDEX objects_p_zmin_index ON objects_p USING btree (zmin);

CREATE INDEX objects_c_attributes_gist ON objects_c USING gist (domain_attrs);

CREATE INDEX objects_c_commit_id_index ON objects_c USING btree (commit_id);

CREATE INDEX objects_c_the_geom_index ON objects_c USING gist (the_geom);

CREATE INDEX objects_c_zmax_index ON objects_c USING btree (zmax);

CREATE INDEX objects_c_zmin_index ON objects_c USING btree (zmin);

CREATE INDEX objects_links_pair_index ON objects_r USING btree (master_id, slave_id);

CREATE INDEX objects_modified_index ON objects USING btree (modified);

CREATE INDEX objects_r_id_index ON objects_r USING btree (id);

CREATE INDEX objects_r_master_id_index ON objects_r USING btree (master_id);

CREATE INDEX objects_r_slave_id_index ON objects_r USING btree (slave_id);

CREATE INDEX objects_the_geom_index ON objects USING gist (the_geom);

CREATE INDEX objects_zmax_index ON objects USING btree (zmax);

CREATE INDEX objects_zmin_index ON objects USING btree (zmin);

CREATE INDEX statistics_attribute_category_id_idx ON statistics USING btree (attribute, category_id);

CREATE TRIGGER insert_objects_l_trigger BEFORE INSERT ON objects_l FOR EACH ROW EXECUTE PROCEDURE objects_l_insert_trigger();

CREATE TRIGGER insert_objects_trigger BEFORE INSERT ON objects_a FOR EACH ROW EXECUTE PROCEDURE objects_insert_trigger();

CREATE TRIGGER update_objects_a10_trigger BEFORE UPDATE ON objects_a10 FOR EACH ROW EXECUTE PROCEDURE objects_update_trigger();

CREATE TRIGGER update_objects_a12_trigger BEFORE UPDATE ON objects_a12 FOR EACH ROW EXECUTE PROCEDURE objects_update_trigger();

CREATE TRIGGER update_objects_a14_trigger BEFORE UPDATE ON objects_a14 FOR EACH ROW EXECUTE PROCEDURE objects_update_trigger();

CREATE TRIGGER update_objects_a16_trigger BEFORE UPDATE ON objects_a16 FOR EACH ROW EXECUTE PROCEDURE objects_update_trigger();

CREATE TRIGGER update_objects_a7_trigger BEFORE UPDATE ON objects_a7 FOR EACH ROW EXECUTE PROCEDURE objects_update_trigger();

CREATE TRIGGER update_objects_a8_trigger BEFORE UPDATE ON objects_a8 FOR EACH ROW EXECUTE PROCEDURE objects_update_trigger();

CREATE TRIGGER update_objects_l10_trigger BEFORE UPDATE ON objects_l10 FOR EACH ROW EXECUTE PROCEDURE objects_l_update_trigger();

CREATE TRIGGER update_objects_l13_trigger BEFORE UPDATE ON objects_l13 FOR EACH ROW EXECUTE PROCEDURE objects_l_update_trigger();

CREATE TRIGGER update_objects_l16_trigger BEFORE UPDATE ON objects_l16 FOR EACH ROW EXECUTE PROCEDURE objects_l_update_trigger();

CREATE TRIGGER update_objects_l9_trigger BEFORE UPDATE ON objects_l9 FOR EACH ROW EXECUTE PROCEDURE objects_l_update_trigger();

-- LABELS

CREATE TABLE labels (
    id bigint NOT NULL,
    containerid bigint,
    bbox public.geometry,
    labeldata bytea,
    objectid bigint,
    labeltext text,
    created timestamp with time zone DEFAULT now(),
    state integer DEFAULT 0 NOT NULL
);
ALTER TABLE labels OWNER TO mapadmin;

CREATE SEQUENCE labels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

ALTER TABLE labels_id_seq OWNER TO mapadmin;

ALTER SEQUENCE labels_id_seq OWNED BY labels.id;

CREATE TABLE labels0 (
    CONSTRAINT labels0_containerid_check CHECK (((containerid >= 0) AND (containerid < 10000)))
)
INHERITS (labels);

ALTER TABLE labels0 OWNER TO mapadmin;

CREATE TABLE labels1 (
    CONSTRAINT labels1_containerid_check CHECK (((containerid >= 10000) AND (containerid < 20000)))
)
INHERITS (labels);

ALTER TABLE labels1 OWNER TO mapadmin;

CREATE TABLE labels10 (
    CONSTRAINT labels10_containerid_check CHECK (((containerid >= 100000) AND (containerid < 110000)))
)
INHERITS (labels);
ALTER TABLE labels10 OWNER TO mapadmin;

CREATE TABLE labels11 (
    CONSTRAINT labels11_containerid_check CHECK (((containerid >= 110000) AND (containerid < 120000)))
)
INHERITS (labels);
ALTER TABLE labels11 OWNER TO mapadmin;

CREATE TABLE labels12 (
    CONSTRAINT labels12_containerid_check CHECK (((containerid >= 120000) AND (containerid < 130000)))
)
INHERITS (labels);
ALTER TABLE labels12 OWNER TO mapadmin;

CREATE TABLE labels13 (
    CONSTRAINT labels13_containerid_check CHECK (((containerid >= 130000) AND (containerid < 140000)))
)
INHERITS (labels);
ALTER TABLE labels13 OWNER TO mapadmin;

CREATE TABLE labels14 (
    CONSTRAINT labels14_containerid_check CHECK (((containerid >= 140000) AND (containerid < 150000)))
)
INHERITS (labels);
ALTER TABLE labels14 OWNER TO mapadmin;

CREATE TABLE labels15 (
    CONSTRAINT labels15_containerid_check CHECK (((containerid >= 150000) AND (containerid < 160000)))
)
INHERITS (labels);
ALTER TABLE labels15 OWNER TO mapadmin;

CREATE TABLE labels16 (
    CONSTRAINT labels16_containerid_check CHECK (((containerid >= 160000) AND (containerid < 170000)))
)
INHERITS (labels);
ALTER TABLE labels16 OWNER TO mapadmin;

CREATE TABLE labels17 (
    CONSTRAINT labels17_containerid_check CHECK (((containerid >= 170000) AND (containerid < 180000)))
)
INHERITS (labels);
ALTER TABLE labels17 OWNER TO mapadmin;

CREATE TABLE labels18 (
    CONSTRAINT labels18_containerid_check CHECK (((containerid >= 180000) AND (containerid < 190000)))
)
INHERITS (labels);
ALTER TABLE labels18 OWNER TO mapadmin;

CREATE TABLE labels19 (
    CONSTRAINT labels19_containerid_check CHECK (((containerid >= 190000) AND (containerid < 200000)))
)
INHERITS (labels);
ALTER TABLE labels19 OWNER TO mapadmin;

CREATE TABLE labels2 (
    CONSTRAINT labels2_containerid_check CHECK (((containerid >= 20000) AND (containerid < 30000)))
)
INHERITS (labels);
ALTER TABLE labels2 OWNER TO mapadmin;

CREATE TABLE labels20 (
    CONSTRAINT labels20_containerid_check CHECK (((containerid >= 200000) AND (containerid < 210000)))
)
INHERITS (labels);
ALTER TABLE labels20 OWNER TO mapadmin;

CREATE TABLE labels21 (
    CONSTRAINT labels21_containerid_check CHECK (((containerid >= 210000) AND (containerid < 220000)))
)
INHERITS (labels);
ALTER TABLE labels21 OWNER TO mapadmin;

CREATE TABLE labels22 (
    CONSTRAINT labels22_containerid_check CHECK (((containerid >= 220000) AND (containerid < 230000)))
)
INHERITS (labels);
ALTER TABLE labels22 OWNER TO mapadmin;

CREATE TABLE labels3 (
    CONSTRAINT labels3_containerid_check CHECK (((containerid >= 30000) AND (containerid < 40000)))
)
INHERITS (labels);
ALTER TABLE labels3 OWNER TO mapadmin;

CREATE TABLE labels4 (
    CONSTRAINT labels4_containerid_check CHECK (((containerid >= 40000) AND (containerid < 50000)))
)
INHERITS (labels);
ALTER TABLE labels4 OWNER TO mapadmin;

CREATE TABLE labels5 (
    CONSTRAINT labels5_containerid_check CHECK (((containerid >= 50000) AND (containerid < 60000)))
)
INHERITS (labels);
ALTER TABLE labels5 OWNER TO mapadmin;

CREATE TABLE labels6 (
    CONSTRAINT labels6_containerid_check CHECK (((containerid >= 60000) AND (containerid < 70000)))
)
INHERITS (labels);
ALTER TABLE labels6 OWNER TO mapadmin;

CREATE TABLE labels7 (
    CONSTRAINT labels7_containerid_check CHECK (((containerid >= 70000) AND (containerid < 80000)))
)
INHERITS (labels);
ALTER TABLE labels7 OWNER TO mapadmin;

CREATE TABLE labels8 (
    CONSTRAINT labels8_containerid_check CHECK (((containerid >= 80000) AND (containerid < 90000)))
)
INHERITS (labels);
ALTER TABLE labels8 OWNER TO mapadmin;

CREATE TABLE labels9 (
    CONSTRAINT labels9_containerid_check CHECK (((containerid >= 90000) AND (containerid < 100000)))
)
INHERITS (labels);
ALTER TABLE labels9 OWNER TO mapadmin;

ALTER TABLE labels ALTER COLUMN id SET DEFAULT nextval('labels_id_seq'::regclass);

ALTER TABLE ONLY labels0
    ADD CONSTRAINT labels0_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels10
    ADD CONSTRAINT labels10_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels11
    ADD CONSTRAINT labels11_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels12
    ADD CONSTRAINT labels12_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels13
    ADD CONSTRAINT labels13_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels14
    ADD CONSTRAINT labels14_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels15
    ADD CONSTRAINT labels15_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels16
    ADD CONSTRAINT labels16_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels17
    ADD CONSTRAINT labels17_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels18
    ADD CONSTRAINT labels18_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels19
    ADD CONSTRAINT labels19_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels1
    ADD CONSTRAINT labels1_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels20
    ADD CONSTRAINT labels20_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels21
    ADD CONSTRAINT labels21_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels22
    ADD CONSTRAINT labels22_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels2
    ADD CONSTRAINT labels2_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels3
    ADD CONSTRAINT labels3_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels4
    ADD CONSTRAINT labels4_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels5
    ADD CONSTRAINT labels5_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels6
    ADD CONSTRAINT labels6_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels7
    ADD CONSTRAINT labels7_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels8
    ADD CONSTRAINT labels8_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels9
    ADD CONSTRAINT labels9_pkey PRIMARY KEY (id);

ALTER TABLE ONLY labels
    ADD CONSTRAINT labels_id_pkey PRIMARY KEY (id);


CREATE INDEX labels0_bbox_index ON labels0 USING gist (bbox);

CREATE INDEX labels0_containerid_index ON labels0 USING btree (containerid);

CREATE INDEX labels0_objectid_index ON labels0 USING btree (objectid);

CREATE INDEX labels10_bbox_index ON labels10 USING gist (bbox);

CREATE INDEX labels10_containerid_index ON labels10 USING btree (containerid);

CREATE INDEX labels10_objectid_index ON labels10 USING btree (objectid);

CREATE INDEX labels11_bbox_index ON labels11 USING gist (bbox);

CREATE INDEX labels11_containerid_index ON labels11 USING btree (containerid);

CREATE INDEX labels11_objectid_index ON labels11 USING btree (objectid);

CREATE INDEX labels12_bbox_index ON labels12 USING gist (bbox);

CREATE INDEX labels12_containerid_index ON labels12 USING btree (containerid);

CREATE INDEX labels12_objectid_index ON labels12 USING btree (objectid);

CREATE INDEX labels13_bbox_index ON labels13 USING gist (bbox);

CREATE INDEX labels13_containerid_index ON labels13 USING btree (containerid);

CREATE INDEX labels13_objectid_index ON labels13 USING btree (objectid);

CREATE INDEX labels14_bbox_index ON labels14 USING gist (bbox);

CREATE INDEX labels14_containerid_index ON labels14 USING btree (containerid);

CREATE INDEX labels14_objectid_index ON labels14 USING btree (objectid);

CREATE INDEX labels15_bbox_index ON labels15 USING gist (bbox);

CREATE INDEX labels15_containerid_index ON labels15 USING btree (containerid);

CREATE INDEX labels15_objectid_index ON labels15 USING btree (objectid);

CREATE INDEX labels16_bbox_index ON labels16 USING gist (bbox);

CREATE INDEX labels16_containerid_index ON labels16 USING btree (containerid);

CREATE INDEX labels16_objectid_index ON labels16 USING btree (objectid);

CREATE INDEX labels17_bbox_index ON labels17 USING gist (bbox);

CREATE INDEX labels17_containerid_index ON labels17 USING btree (containerid);

CREATE INDEX labels17_objectid_index ON labels17 USING btree (objectid);

CREATE INDEX labels18_bbox_index ON labels18 USING gist (bbox);

CREATE INDEX labels18_containerid_index ON labels18 USING btree (containerid);

CREATE INDEX labels18_objectid_index ON labels18 USING btree (objectid);

CREATE INDEX labels19_bbox_index ON labels19 USING gist (bbox);

CREATE INDEX labels19_containerid_index ON labels19 USING btree (containerid);

CREATE INDEX labels19_objectid_index ON labels19 USING btree (objectid);

CREATE INDEX labels1_bbox_index ON labels1 USING gist (bbox);

CREATE INDEX labels1_containerid_index ON labels1 USING btree (containerid);

CREATE INDEX labels1_objectid_index ON labels1 USING btree (objectid);

CREATE INDEX labels20_bbox_index ON labels20 USING gist (bbox);

CREATE INDEX labels20_containerid_index ON labels20 USING btree (containerid);

CREATE INDEX labels20_objectid_index ON labels20 USING btree (objectid);

CREATE INDEX labels21_bbox_index ON labels21 USING gist (bbox);

CREATE INDEX labels21_containerid_index ON labels21 USING btree (containerid);

CREATE INDEX labels21_objectid_index ON labels21 USING btree (objectid);

CREATE INDEX labels22_bbox_index ON labels22 USING gist (bbox);

CREATE INDEX labels22_containerid_index ON labels22 USING btree (containerid);

CREATE INDEX labels22_objectid_index ON labels22 USING btree (objectid);

CREATE INDEX labels2_bbox_index ON labels2 USING gist (bbox);

CREATE INDEX labels2_containerid_index ON labels2 USING btree (containerid);

CREATE INDEX labels2_objectid_index ON labels2 USING btree (objectid);

CREATE INDEX labels3_bbox_index ON labels3 USING gist (bbox);

CREATE INDEX labels3_containerid_index ON labels3 USING btree (containerid);

CREATE INDEX labels3_objectid_index ON labels3 USING btree (objectid);

CREATE INDEX labels4_bbox_index ON labels4 USING gist (bbox);

CREATE INDEX labels4_containerid_index ON labels4 USING btree (containerid);

CREATE INDEX labels4_objectid_index ON labels4 USING btree (objectid);

CREATE INDEX labels5_bbox_index ON labels5 USING gist (bbox);

CREATE INDEX labels5_containerid_index ON labels5 USING btree (containerid);

CREATE INDEX labels5_objectid_index ON labels5 USING btree (objectid);

CREATE INDEX labels6_bbox_index ON labels6 USING gist (bbox);

CREATE INDEX labels6_containerid_index ON labels6 USING btree (containerid);

CREATE INDEX labels6_objectid_index ON labels6 USING btree (objectid);

CREATE INDEX labels7_bbox_index ON labels7 USING gist (bbox);

CREATE INDEX labels7_containerid_index ON labels7 USING btree (containerid);

CREATE INDEX labels7_objectid_index ON labels7 USING btree (objectid);

CREATE INDEX labels8_bbox_index ON labels8 USING gist (bbox);

CREATE INDEX labels8_containerid_index ON labels8 USING btree (containerid);

CREATE INDEX labels8_objectid_index ON labels8 USING btree (objectid);

CREATE INDEX labels9_bbox_index ON labels9 USING gist (bbox);

CREATE INDEX labels9_containerid_index ON labels9 USING btree (containerid);

CREATE INDEX labels9_objectid_index ON labels9 USING btree (objectid);

COMMIT;
