#pragma once

#include "registry.h"
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/format.h>
#include <maps/wikimap/mapspro/services/editor/src/objectvisitor.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

namespace maps {
namespace wiki {

class ObjectsCache;

namespace srv_attrs
{

class CalcSrvAttrs
{
public:
    typedef std::map<TOid, std::string> ObjectsNames;

    CalcSrvAttrs(ObjectsCache& cache);

    void process(const ObjectPtr& obj);
    ObjectsCache& cache() const
    { return cache_; }
    static std::string calcErrorHotSpotLabel(const std::string& attrsHstore);
    static std::string calcMergeRegionHotSpotLabel(const std::string& attrsHstore);
    SuggestTexts suggestTexts(TOid oid) const;

    static bool hasRealtimeHotSpotLabel(const std::string& categoryId);
    static std::string calcRealtimeHotSpotLabel(const std::string& attrsHstore, const std::string& categoryId);

private:
    ObjectsCache& cache_;

};

std::string objectNameByType(
    TOid oid, const std::string& nmType, ObjectsCache& cache, const std::string& lang = std::string());

template <typename Attrs>
std::string
getValueLabel(const Attrs& attrs, const std::string& name)
{
    auto it = attrs.find(name);
    if (it == attrs.end()) {
        THROW_WIKI_INTERNAL_ERROR("unexisted attribute " << name);
    }
    if (it->second.empty()) {
        THROW_WIKI_INTERNAL_ERROR("empty value of attribute " << name);
    }
    return valueLabel(name, it->second);
}

} //srv_attrs
} // namespace wiki
} // namespace maps
