#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

namespace maps {
namespace wiki {

class GeoObject;
class IsPartOfSimpleContourObject
{
private:
    enum class ContourObjectStructure
    {
        Unknown,
        Simple,
        NotSimple
    };
public:
    bool operator ()(const GeoObject* obj);

private:
    ContourObjectStructure result(TOid) const;
    void setSimple(TOid);
    void setNotSimple(TOid);

    std::map<TOid, ContourObjectStructure> results_;

};

}//wiki
}//maps
