#pragma once
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/relation_infos.h>
#include <vector>

namespace maps
{
namespace wiki
{
namespace srv_attrs
{
class RelationsStep
{
public:
    enum class Selection
    {
        Diff,
        Full
    };

    RelationsStep(RelationType direction,
            const std::string& roleId,
            const std::string& categoryId)
        : direction_(direction)
        , roleId_(roleId)
        , categoryId_(categoryId){}

    template<typename ObjectCollection>
    std::vector<GeoObject*> backward(const ObjectCollection& objects, Selection selection) const;

    const std::string& categoryId() const { return categoryId_; }
    RelationType direction() const { return direction_; }

    const std::string& roleId() const { return roleId_; }

private:
    RelationType direction_;
    std::string roleId_;
    std::string categoryId_;
};

class RelationsPath
{
public:
    RelationsPath() = default;
    RelationsPath(std::initializer_list<RelationsStep> steps) : steps_(steps){}

    std::vector<GeoObject*> backward(const std::vector<const GeoObject*>&, size_t startPos) const;
    RelationsPath&& operator ()(RelationsStep&&);
    const std::vector<RelationsStep>& steps() const { return steps_; }

private:
    std::vector<RelationsStep> steps_;
};
}//srv_attrs
}//wiki
}//maps
