#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>

#include <maps/libs/pgpool/include/pgpool3.h>
#include <yandex/maps/wiki/revision/filters.h>
#include <yandex/maps/wiki/revision/branch.h>

#include <queue>

namespace maps {
namespace wiki {
namespace sync {

const std::string STR_FALSE = "false";
const std::string STR_TRUE = "true";
const std::string STR_NULL = "NULL";

const std::string STR_DOMAIN_ATTRS = "domain_attrs";
const std::string STR_CATEGORIES = "categories";

const std::string TABLE_SUGGEST_DATA = "suggest_data";
const std::string TABLE_LABELS = "labels";

const std::string ID = "id";

std::string masterCoreConnectionString();

bool isSplittedViewLabels(TBranchId branchId);

inline pgpool3::TransactionHandle
masterCoreTransaction(AccessMode mode)
{
    auto conn = cfg()->poolCore().getMasterConnection();
    return mode == AccessMode::ReadOnly
        ? pgpool3::makeReadOnlyTransaction(std::move(conn))
        : pgpool3::makeWriteableTransaction(std::move(conn));
}

std::string masterConnectionString(const pgpool3::PoolState& state);

class BranchLocker
{
public:
    explicit BranchLocker(pgpool3::TransactionHandle& txn);
    explicit BranchLocker(const std::string& connectionString);
    ~BranchLocker();

    pqxx::transaction_base& work() const;

    void lockBranchPersistently(
        const revision::Branch& branch, revision::Branch::LockType lockType) const;

    void lockWaitExclusive(
        const revision::Branch& branch, revision::Branch::LockId lockId) const;

    bool tryLockExclusive(
        const revision::Branch& branch, revision::Branch::LockId lockId) const;

private:
    pgpool3::TransactionHandle* pooledTxn_;
    std::unique_ptr<pqxx::connection> conn_;
    std::unique_ptr<pqxx::work> txn_;
};

struct RelationsCategories
{
    StringSet master;
    StringSet slave;
};

RelationsCategories
relationsCategories(
    const StringSet& objectsCategories,
    const StringSet& availableCategories);


revision::filters::ProxyFilterExpr
headObjectIdsFilter(const StringSet& objectsCategories);

revision::filters::ProxyFilterExpr
headObjectIdsFilter(const std::string& categoryId);

std::string
objectsVRevisionsFilter(const StringSet& objectsCategories);

std::string
suggestVRevisionsFilter(const StringSet& objectsCategories);

revision::filters::ProxyFilterExpr
headRelationIdsFilter(
    const StringSet& objectsCategories,
    const RelationsCategories& relationsCategories,
    const StringVec& forbiddenRoles);

std::string
relationsVRevisionsFilter(
    const StringSet& objectsCategories,
    const RelationsCategories& relationsCategories);

TOIds
headObjectIds(
    pqxx::transaction_base& work,
    TCommitId commitId,
    const revision::Branch& branch,
    const revision::filters::ProxyFilterExpr& filter);

boost::optional<TOIds>
tryLoadHeadObjectIds(
    pqxx::transaction_base& work,
    TCommitId commitId, const revision::Branch& branch,
    const revision::filters::ProxyFilterExpr& filter, size_t limit);

TCommitId
findNonServiceStartCommitId(
    pqxx::transaction_base& work, const TCommitIds& commitIds);

size_t
maxThreadsCount(TBranchId branchId);

std::set<std::string>
findBranchViews(pqxx::transaction_base& work, TBranchId branchId);

} // namespace sync
} // namespace wiki
} // namespace maps
