#include "dependent_info.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include <maps/wikimap/mapspro/services/editor/src/rendererpool.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>
#include <maps/wikimap/mapspro/services/editor/src/srv_attrs/registry.h>
#include <maps/wikimap/mapspro/services/editor/src/objects/relation_object.h>
#include <yandex/maps/wiki/configs/editor/categories.h>
#include <vector>

namespace maps {
namespace wiki {
namespace sync {

void
DependentInfo::enableCollectSrvAttrsObjectIds()
{
    srvAttrsCategories_ =
        srv_attrs::ServiceAttributesRegistry::get().registeredCategories();
}
void
DependentInfo::enableCollectSuggestObjectIds()
{
    suggestCategories_ = cfg()->editor()->categories().idsByFilter(Categories::Suggest);
}
void
DependentInfo::enableCollectLabeledObjectIds()
{
    labeledCategories_ = cfg()->rendererPool()->labeledCategories();
}

void DependentInfo::updateData(const TOIds& oids, ObjectsCache& cache)
{
    std::vector<TOid> srvAttrsOids;
    std::vector<TOid> labeledOids;
    std::vector<TOid> suggestOids;

    srv_attrs::preloadDependentObjects(oids, cache);

    auto filter = [&] (const GeoObject* object)
    {
        if (!is<RelationObject>(object)) {
            const auto& categoryId = object->categoryId();
            if (srvAttrsCategories_.count(categoryId)) {
                srvAttrsOids.push_back(object->id());
            }
            if (suggestCategories_.count(categoryId)) {
                suggestOids.push_back(object->id());
            }
            if (labeledCategories_.count(categoryId)) {
                labeledOids.push_back(object->id());
            }
        }
        return false;
    };
    cache.find(filter);

    std::lock_guard<std::mutex> lock(mutex_);
    srvAttrsObjectIds_.insert(srvAttrsOids.begin(), srvAttrsOids.end());
    suggestObjectIds_.insert(suggestOids.begin(), suggestOids.end());
    labeledObjectIds_.insert(labeledOids.begin(), labeledOids.end());
}

TOIds
DependentInfo::loadSrvAttrsObjectIds()
{
    TOIds result;
    std::lock_guard<std::mutex> lock(mutex_);
    result.swap(srvAttrsObjectIds_);
    return result;
}

TOIds
DependentInfo::loadSuggestObjectIds()
{
    TOIds result;
    std::lock_guard<std::mutex> lock(mutex_);
    result.swap(suggestObjectIds_);
    return result;
}

TOIds
DependentInfo::loadLabeledObjectIds()
{
    TOIds result;
    std::lock_guard<std::mutex> lock(mutex_);
    result.swap(labeledObjectIds_);
    return result;
}

} // namespace sync
} // namespace wiki
} // namespace maps
