#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <boost/noncopyable.hpp>
#include <mutex>
#include <unordered_set>

namespace maps {
namespace wiki {

class ObjectsCache;

namespace sync {

class DependentInfo : boost::noncopyable
{
public:
    DependentInfo() = default;

    void enableCollectSrvAttrsObjectIds();
    void enableCollectLabeledObjectIds();
    void enableCollectSuggestObjectIds();

    void updateData(const TOIds& oids, ObjectsCache& cache);

    TOIds loadSrvAttrsObjectIds();
    TOIds loadSuggestObjectIds();
    TOIds loadLabeledObjectIds();


private:
    std::mutex mutex_;
    StringSet srvAttrsCategories_;
    StringSet suggestCategories_;
    StringSet labeledCategories_;
    TOIds srvAttrsObjectIds_;
    TOIds suggestObjectIds_;
    TOIds labeledObjectIds_;
};

} // namespace sync
} // namespace wiki
} // namespace maps
