#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/common/pg_advisory_lock_ids.h>

namespace maps {
namespace wiki {
namespace sync {

enum class LockType
{
    Shared,
    Exclusive
};

void lockDb(pqxx::transaction_base& work, common::AdvisoryLockIds lockId, LockType lockType);
bool tryLockDb(pqxx::transaction_base& work, common::AdvisoryLockIds lockId, LockType lockType);

void lockViews(pqxx::transaction_base& work, LockType lockType);
bool tryLockViews(pqxx::transaction_base& work, LockType lockType);

} // namespace sync
} // namespace wiki
} // namespace maps
