#pragma once

#include "sync_params.h"
#include <maps/wikimap/mapspro/services/editor/src/common.h>

#include <yandex/maps/wiki/revision/branch.h>
#include <maps/libs/common/include/exception.h>

#include <memory>

namespace maps {
namespace wiki {
namespace sync {

class TargetTables;
class SyncProcessor;
class BranchLocker;

class SyncObjects
{
public:
    SyncObjects(
        SyncParams&& params,
        BranchLocker& branchLocker);
    ~SyncObjects();

    SyncObjects(SyncObjects&& rhs);
    SyncObjects& operator=(SyncObjects&& rhs) = delete;

    const revision::Branch& branch() const { return branch_; }

    void run(CustomIds customIds);

private:
    void initCustomIds(CustomIds customIds);
    void rebuildData();

    void clearTargetTablesByFlags();

    void rebuildDataForCustomObjectIds() const;
    void rebuildDataForAllObjectIds() const;

    void rebuildBBoxes(boost::optional<TCommitIds> customCommitIds) const;

    void rebuildAllObjectsView() const;
    void rebuildAllObjectsViewForCategories(const StringSet& objectsCategories) const;
    void rebuildAllRelationsViewForCategories(const StringSet& objectsCategories) const;

    void rebuildAllObjectsAttrs() const;
    void rebuildAllObjectsSuggest() const;
    void rebuildAllObjectsLabels() const;

    SyncParams params_;
    BranchLocker& branchLocker_;
    revision::Branch branch_;
    std::unique_ptr<TargetTables> targetTables_;

    boost::optional<TOIds> customObjectIds_;
    boost::optional<TCommitIds> customCommitIds_;

    StringSet labeledCategories_;
    boost::optional<TOIds> labeledObjectIds_;
};

} // namespace sync
} // namespace wiki
} // namespace maps
