#pragma once

#include "tasks.h"
#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <yandex/maps/wiki/threadutils/threadpool.h>
#include <memory>

namespace maps {
namespace wiki {
namespace sync {

class TargetTables;
class SyncParams;

class SyncProcessor
{
public:
    explicit SyncProcessor(
        const TargetTables& targetTables,
        size_t threads = 0);

    void processObjects(
        const TOIds& oids,
        const Tasks::TaskInfo& taskInfo);

    void wait(); // wait all batch tasks

private:
    const TargetTables& targetTables_;
    std::unique_ptr<ThreadPool> threadPool_;
};

} // namespace sync
} // namespace wiki
} // namespace maps
