#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <yandex/maps/wiki/revision/branch.h>

namespace maps {
namespace wiki {
namespace sync {

class SyncParams;

class TargetTables
{
public:
    explicit TargetTables(const SyncParams& params);

    const revision::Branch& branch() const { return branch_; }
    const SyncParams& syncParams() const { return params_; }

    bool isViewEmpty() const { return viewEmpty_; }
    bool isSuggestEmpty() const { return suggestEmpty_; }
    bool areLabelsEmpty() const { return labelsEmpty_; }

    void createSchemaIfNotExists();

    void clearView(Transaction& work);
    void clearSuggestData(Transaction& work);

    void clearAllLabels(Transaction& work);

private:
    revision::Branch branch_;
    const SyncParams& params_;
    const std::string schemaName_;
    bool viewEmpty_;
    bool suggestEmpty_;
    bool labelsEmpty_;
};

} // namespace sync
} // namespace wiki
} // namespace maps
