#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/branch_helpers.h>
#include <boost/optional.hpp>

namespace maps {
namespace wiki {
namespace sync {

class SyncFlags;
class TargetTables;
class DependentInfo;
struct RetryParams;

class Tasks
{
public:
    Tasks(
        const TargetTables& targetTables,
        const TOIds& oids,
        std::string logContext);

    typedef std::function<void(const Tasks& tasks)> TasksMethod;

    struct TaskInfo
    {
        TasksMethod method;
        std::string name;
        size_t maxBatchSize;
    };

    static TaskInfo passDependentInfo(DependentInfo& dependentInfo);

    static boost::optional<TaskInfo> passView(const SyncFlags& flags);
    static boost::optional<TaskInfo> passAttrs(const SyncFlags& flags);
    static boost::optional<TaskInfo> passSuggest(const SyncFlags& flags);
    static boost::optional<TaskInfo> passLabels(const SyncFlags& flags);

private:
    void writeObjectView() const;
    void updateViewSrvAttrs() const;
    void updateSuggest() const;
    void updateLabels() const;
    void updateDependentInfo(DependentInfo& dependentInfo) const;

    void execWithRetry(
        std::function<std::string(void)> function,
        const RetryParams& params) const;

private:
    const TargetTables& targetTables_;
    const TOIds& oids_;
    const std::string logContext_;
};

} // namespace sync
} // namespace wiki
} // namespace maps
