UNITTEST()

OWNER(g:maps-nmaps)

PEERDIR(
    library/cpp/testing/gmock_in_unittest
    maps/wikimap/mapspro/libs/revisionapi
    maps/wikimap/mapspro/libs/unittest
    maps/wikimap/mapspro/services/editor/src/actions
    maps/wikimap/mapspro/services/editor/src/lib/editor-common
    maps/wikimap/mapspro/services/editor/src/lib/editor-daemon
    maps/wikimap/mapspro/services/editor/src/observers
    maps/wikimap/mapspro/services/editor/src/serialize
    maps/wikimap/mapspro/services/editor/src/tests/helpers
    maps/wikimap/mapspro/services/editor/src/topological
)

DATA(
    arcadia/maps/wikimap/mapspro/cfg/editor
    arcadia/maps/wikimap/mapspro/cfg/layers
    arcadia/maps/wikimap/mapspro/cfg/services
    arcadia/maps/wikimap/mapspro/schemas
    arcadia/maps/wikimap/mapspro/services/editor/src/tests
    arcadia/maps/wikimap/mapspro/migrations/migrations
)

DEPENDS(
    maps/tools/json-validator
    contrib/tools/xmllint
)

SRCS(
    autoassign_station_to_route.cpp
    cant_break_closure.cpp
    cant_delete_last_ad_fc.cpp
    cant_save_invalid_contour.cpp
    change_vegetation_and_moderate_tasks.cpp
    clear_user_comments.cpp
    clone_object.cpp
    contour_validity.cpp
    create_3_bld.cpp
    create_ad_el.cpp
    create_ad_el_and_comment.cpp
    create_ad_el_and_revert.cpp
    create_addr_and_set_lang.cpp
    create_and_split_rd_el_with_addr_ranges.cpp
    create_aoi.cpp
    create_aoi_and_get_moderation_dashboard.cpp
    create_aoi_and_get_moderation_regions.cpp
    create_aoi_and_moderate_tasks.cpp
    create_intersections_vegetation.cpp
    create_river_and_set_is_local.cpp
    create_road_and_bind_to_city.cpp
    create_sprav_poi.cpp
    create_too_long_rd_el.cpp
    create_vegetation.cpp
    delete_simple_object_cascade.cpp
    delete_unused_jc_on_fc_deletion.cpp
    event_alerts.cpp
    get_commit.cpp
    get_commit_diff.cpp
    get_dashboard_meta.cpp
    get_feedback_task_history.cpp
    get_geolocks.cpp
    get_object_ad_center_substitute.cpp
    get_object_branch_diff.cpp
    get_object_override.cpp
    get_route_time.cpp
    get_topology.cpp
    layers.cpp
    make_junction.cpp
    objects_cleanup.cpp
    objects_query_path.cpp
    objects_query_poi_conflicts.cpp
    objects_query_route_diff.cpp
    objects_update_attributes.cpp
    objects_update_attributes_meta.cpp
    objects_update_merge.cpp
    objects_update_move.cpp
    objects_update_move_meta.cpp
    point_to_bld.cpp
    prohibited_objects.cpp
    save_branch_state.cpp
    save_closed_rd_el.cpp
    save_delete_unused.cpp
    save_object_attributes_update.cpp
    save_object_change_category.cpp
    save_object_sanitize_shadow_attributes.cpp
    save_with_commit_attributes.cpp
    split_building.cpp
    split_parking_lot_linear.cpp
    srv_attrs.cpp
    subscriptions.cpp
    suggest.cpp
    tools_pedestrian_points.cpp
    update_seq_nums.cpp
)


REQUIREMENTS(ram:32)
SIZE(MEDIUM)
INCLUDE(${ARCADIA_ROOT}/maps/pylibs/recipes/postgres/recipe.inc)
FORK_SUBTESTS()

IF (DEFINED AUTOCHECK)
    SPLIT_FACTOR(6)
ELSE()
    SPLIT_FACTOR(12)
ENDIF()

END()
