#include "db_helpers.h"
#include <maps/wikimap/mapspro/services/editor/src/configs/config.h>
#include "helpers.h"
#include "tests_common.h"

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/filesystem.hpp>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <fstream>
#include <iostream>
#include <set>

namespace maps {
namespace wiki {
namespace tests {

namespace {
const std::string SUPERVISOR_DELAY = "'30 minutes'::interval";
}

revision::ObjectRevision
getObjRevision(const std::string& categoryId)
{
    auto work = cfg()->poolCore().masterReadOnlyTransaction();
    revision::RevisionsGateway revGateway(*work);
    auto snapshot = revGateway.snapshot(revGateway.headCommitId());
    auto revs = snapshot.objectRevisionsByFilter(
        revision::filters::Attr(plainCategoryIdToCanonical(categoryId)).defined());
    EXPECT_TRUE(revs.size() == 1);
    return revs.front();
}

TRevisionId
getObjRevisionId(const std::string& categoryId)
{
    return getObjRevision(categoryId).id();
}

revision::ObjectRevision
getAoiRevision()
{
    return getObjRevision(CATEGORY_AOI);
}

TRevisionId
getAoiRevisionId()
{
    return getAoiRevision().id();
}

void
adjustTasksResolveTimeBySupervisorDelay()
{
    auto work = cfg()->poolSocial().masterWriteableTransaction();
    auto query =
        "UPDATE social.task SET resolved_at = resolved_at - " +
            SUPERVISOR_DELAY + " - '10 minutes'::interval";
    work->exec(query);
    work->commit();
}

} // namespace tests
} // namespace wiki
} // namespace maps
