#include "extended_editor_fixture.h"

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::tests {

constexpr maps::enum_io::Representations<UserType> USER_TYPE_REPRESENTATION {
    {UserType::Common,       "Common"},
    {UserType::Moderator,    "Moderator"},
    {UserType::Cartographer, "Cartographer"}
};
DEFINE_ENUM_IO(UserType, USER_TYPE_REPRESENTATION);

constexpr maps::enum_io::Representations<RevertMode> REVERT_MODE_REPRESENTATION {
    {RevertMode::Commit,  "Commit"},
    {RevertMode::Resolve, "Resolve"},
    {RevertMode::Close,   "Close"}
};
DEFINE_ENUM_IO(RevertMode, REVERT_MODE_REPRESENTATION);

} // namespace maps::wiki::tests
