#pragma once

#include <maps/wikimap/mapspro/services/editor/src/common.h>
#include <maps/wikimap/mapspro/services/editor/src/objects_cache.h>

#include <maps/libs/json/include/value.h>

#include <initializer_list>
#include <string>
#include <vector>

namespace maps {
namespace wiki {
namespace tests {

std::string loadFile(const std::string& path);

std::string prettifyXml(const std::string& originalXml);

void initJsonSchemas();
void validateJsonRequest(const std::string& json, const std::string& taskName);
void validateJsonResponse(const std::string& json, const std::string& taskName);

void validateXmlResponse(const std::string& xml);

std::string toString(const std::vector<TOid>& ids);

std::string toString(const revision::RevisionID& revisionId);

void toIdArray(json::ArrayBuilder array, std::initializer_list<TOid> ids);

ObjectPtr getObject(const std::string& categoryId);

TOIds objectIdsByCategory(const ObjectsCache& cache, const std::string& categoryName);

} // namespace tests
} // namespace wiki
} // namespace maps
